/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.ss;

import org.cicirello.permutations.Permutation;
import org.cicirello.search.ss.Partial;

public final class PartialPermutation
implements Partial<Permutation> {
    private final int[] partial;
    private final int[] remainingElements;
    private int size;
    private int remaining;

    public PartialPermutation(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("n must not be negative");
        }
        this.partial = new int[n];
        this.remainingElements = new int[n];
        for (int i = 1; i < n; ++i) {
            this.remainingElements[i] = i;
        }
        this.remaining = n;
    }

    @Override
    public Permutation toComplete() {
        if (this.remaining > 0) {
            System.arraycopy(this.remainingElements, 0, this.partial, this.size, this.remaining);
        }
        return new Permutation(this.partial);
    }

    @Override
    public boolean isComplete() {
        return this.remaining == 0;
    }

    @Override
    public int get(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException("index must be less than size");
        }
        return this.partial[index];
    }

    @Override
    public int getLast() {
        return this.partial[this.size - 1];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int numExtensions() {
        return this.remaining;
    }

    @Override
    public int getExtension(int extensionIndex) {
        if (extensionIndex >= this.remaining) {
            throw new ArrayIndexOutOfBoundsException("extensionIndex must be less than numExtensions()");
        }
        return this.remainingElements[extensionIndex];
    }

    @Override
    public void extend(int extensionIndex) {
        if (extensionIndex >= this.remaining) {
            throw new ArrayIndexOutOfBoundsException("extensionIndex must be less than numExtensions()");
        }
        this.partial[this.size] = this.remainingElements[extensionIndex];
        ++this.size;
        --this.remaining;
        this.remainingElements[extensionIndex] = this.remainingElements[this.remaining];
    }
}

