/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.ss;

import java.util.Arrays;
import org.cicirello.search.representations.BoundedIntegerVector;
import org.cicirello.search.representations.IntegerVector;
import org.cicirello.search.ss.Partial;

public final class PartialIntegerVector
implements Partial<IntegerVector> {
    private final int min;
    private final int max;
    private int extendCount;
    private final boolean enforceBounds;
    private final int[] partial;
    private int size;

    public PartialIntegerVector(int n, int min, int max) {
        this(n, min, max, true);
    }

    public PartialIntegerVector(int n, int min, int max, boolean enforceBounds) {
        if (n < 0) {
            throw new IllegalArgumentException("n must not be negative");
        }
        if (min > max) {
            throw new IllegalArgumentException("min must be less than or equal to max");
        }
        this.min = min;
        this.max = max;
        this.extendCount = n > 0 ? max - min + 1 : 0;
        this.enforceBounds = enforceBounds;
        this.partial = new int[n];
    }

    @Override
    public IntegerVector toComplete() {
        if (this.size < this.partial.length) {
            Arrays.fill(this.partial, this.size, this.partial.length, this.min);
        }
        return this.enforceBounds ? new BoundedIntegerVector(this.partial, this.min, this.max) : new IntegerVector(this.partial);
    }

    @Override
    public boolean isComplete() {
        return this.size == this.partial.length;
    }

    @Override
    public int get(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException("index must be less than size");
        }
        return this.partial[index];
    }

    @Override
    public int getLast() {
        return this.partial[this.size - 1];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int numExtensions() {
        return this.extendCount;
    }

    @Override
    public int getExtension(int extensionIndex) {
        if (extensionIndex >= this.extendCount) {
            throw new ArrayIndexOutOfBoundsException("extensionIndex must be less than numExtensions()");
        }
        return this.min + extensionIndex;
    }

    @Override
    public void extend(int extensionIndex) {
        if (extensionIndex >= this.extendCount) {
            throw new ArrayIndexOutOfBoundsException("extensionIndex must be less than numExtensions()");
        }
        this.partial[this.size] = this.min + extensionIndex;
        ++this.size;
        if (this.size == this.partial.length) {
            this.extendCount = 0;
        }
    }
}

