/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.ss;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntSupplier;
import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.search.problems.Problem;
import org.cicirello.search.ss.ConstructiveHeuristic;
import org.cicirello.search.ss.IncrementalEvaluation;
import org.cicirello.search.ss.Partial;
import org.cicirello.util.Copyable;

public final class HybridConstructiveHeuristic<T extends Copyable<T>>
implements ConstructiveHeuristic<T> {
    private final ArrayList<ConstructiveHeuristic<T>> heuristics;
    private final int NUM_H;
    private final IntSupplier heuristicSelector;

    public HybridConstructiveHeuristic(List<? extends ConstructiveHeuristic<T>> heuristics) {
        this(heuristics, false);
    }

    public HybridConstructiveHeuristic(List<? extends ConstructiveHeuristic<T>> heuristics, boolean roundRobin) {
        this.heuristics = this.initializeHeuristics(heuristics);
        this.NUM_H = heuristics.size();
        this.heuristicSelector = roundRobin ? new IntSupplier(){
            AtomicInteger lastHeuristic;
            {
                this.lastHeuristic = new AtomicInteger(HybridConstructiveHeuristic.this.NUM_H - 1);
            }

            @Override
            public int getAsInt() {
                return this.lastHeuristic.updateAndGet(h -> {
                    if (++h == HybridConstructiveHeuristic.this.NUM_H) {
                        h = 0;
                    }
                    return h;
                });
            }
        } : () -> RandomIndexer.nextBiasedInt((int)this.NUM_H);
    }

    public HybridConstructiveHeuristic(List<? extends ConstructiveHeuristic<T>> heuristics, int[] weights) {
        if (weights.length != heuristics.size()) {
            throw new IllegalArgumentException("The number of weights must be the same as the number of heuristics.");
        }
        this.heuristics = this.initializeHeuristics(heuristics);
        this.NUM_H = weights.length;
        int[] choice = (int[])weights.clone();
        if (choice[0] <= 0) {
            throw new IllegalArgumentException("All weights must be positive.");
        }
        for (int i = 1; i < this.NUM_H; ++i) {
            if (choice[i] <= 0) {
                throw new IllegalArgumentException("All weights must be positive.");
            }
            int n = i;
            choice[n] = choice[n] + choice[i - 1];
        }
        this.heuristicSelector = () -> {
            int which = Arrays.binarySearch(choice, RandomIndexer.nextInt((int)choice[this.NUM_H - 1]));
            return which < 0 ? -(which + 1) : which + 1;
        };
    }

    private ArrayList<ConstructiveHeuristic<T>> initializeHeuristics(List<? extends ConstructiveHeuristic<T>> heuristics) {
        if (heuristics.size() == 0) {
            throw new IllegalArgumentException("Must pass at least one heuristic.");
        }
        ConstructiveHeuristic<T> first = null;
        for (ConstructiveHeuristic<T> h : heuristics) {
            if (first == null) {
                first = h;
                continue;
            }
            if (h.getProblem() == first.getProblem()) continue;
            throw new IllegalArgumentException("All heuristics must be configured for the same problem.");
        }
        return new ArrayList<ConstructiveHeuristic<T>>(heuristics);
    }

    @Override
    public IncrementalEvaluation<T> createIncrementalEvaluation() {
        int which = this.heuristicSelector.getAsInt();
        IncrementalEvaluationWrapper<T> wrapped = new IncrementalEvaluationWrapper<T>(this.heuristics.get(which).createIncrementalEvaluation(), which);
        return wrapped;
    }

    @Override
    public double h(Partial<T> p, int element, IncrementalEvaluation<T> incEval) {
        IncrementalEvaluationWrapper wrapped = (IncrementalEvaluationWrapper)incEval;
        return this.heuristics.get(wrapped.which).h(p, element, wrapped.incEval);
    }

    @Override
    public Partial<T> createPartial(int n) {
        return this.heuristics.get(0).createPartial(n);
    }

    @Override
    public int completeLength() {
        return this.heuristics.get(0).completeLength();
    }

    @Override
    public Problem<T> getProblem() {
        return this.heuristics.get(0).getProblem();
    }

    private static class IncrementalEvaluationWrapper<U extends Copyable<U>>
    implements IncrementalEvaluation<U> {
        private final IncrementalEvaluation<U> incEval;
        private final int which;

        public IncrementalEvaluationWrapper(IncrementalEvaluation<U> incEval, int which) {
            this.incEval = incEval;
            this.which = which;
        }

        @Override
        public void extend(Partial<U> p, int element) {
            this.incEval.extend(p, element);
        }
    }
}

