/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.ss;

import org.cicirello.search.ProgressTracker;
import org.cicirello.search.SimpleMetaheuristic;
import org.cicirello.search.SolutionCostPair;
import org.cicirello.search.problems.IntegerCostOptimizationProblem;
import org.cicirello.search.problems.OptimizationProblem;
import org.cicirello.search.problems.Problem;
import org.cicirello.search.ss.ConstructiveHeuristic;
import org.cicirello.search.ss.IncrementalEvaluation;
import org.cicirello.search.ss.Partial;
import org.cicirello.util.Copyable;

public class HeuristicSolutionGenerator<T extends Copyable<T>>
implements SimpleMetaheuristic<T> {
    private final OptimizationProblem<T> pOpt;
    private final IntegerCostOptimizationProblem<T> pOptInt;
    private final ConstructiveHeuristic<T> heuristic;
    private ProgressTracker<T> tracker;
    private int numGenerated;

    public HeuristicSolutionGenerator(ConstructiveHeuristic<T> heuristic) {
        this(heuristic, new ProgressTracker());
    }

    public HeuristicSolutionGenerator(ConstructiveHeuristic<T> heuristic, ProgressTracker<T> tracker) {
        if (heuristic == null || tracker == null) {
            throw new NullPointerException();
        }
        this.tracker = tracker;
        this.heuristic = heuristic;
        Problem<T> problem = heuristic.getProblem();
        if (heuristic.getProblem() instanceof IntegerCostOptimizationProblem) {
            this.pOptInt = (IntegerCostOptimizationProblem)problem;
            this.pOpt = null;
        } else {
            this.pOpt = (OptimizationProblem)problem;
            this.pOptInt = null;
        }
    }

    HeuristicSolutionGenerator(HeuristicSolutionGenerator<T> other) {
        this.pOpt = other.pOpt;
        this.pOptInt = other.pOptInt;
        this.heuristic = other.heuristic;
        this.tracker = other.tracker;
    }

    @Override
    public final SolutionCostPair<T> optimize() {
        if (this.tracker.isStopped() || this.tracker.didFindBest()) {
            return null;
        }
        ++this.numGenerated;
        return this.generate();
    }

    @Override
    public final ProgressTracker<T> getProgressTracker() {
        return this.tracker;
    }

    @Override
    public final void setProgressTracker(ProgressTracker<T> tracker) {
        if (tracker != null) {
            this.tracker = tracker;
        }
    }

    @Override
    public final long getTotalRunLength() {
        return this.numGenerated;
    }

    @Override
    public final Problem<T> getProblem() {
        return this.pOptInt != null ? this.pOptInt : this.pOpt;
    }

    @Override
    public HeuristicSolutionGenerator<T> split() {
        return new HeuristicSolutionGenerator<T>(this);
    }

    private SolutionCostPair<T> evaluateAndPackageSolution(T complete) {
        if (this.pOptInt != null) {
            SolutionCostPair<T> solution = this.pOptInt.getSolutionCostPair(complete);
            int cost = solution.getCost();
            if (cost < this.tracker.getCost()) {
                this.tracker.update(cost, complete, this.pOptInt.isMinCost(cost));
            }
            return solution;
        }
        SolutionCostPair<T> solution = this.pOpt.getSolutionCostPair(complete);
        double cost = solution.getCostDouble();
        if (cost < this.tracker.getCostDouble()) {
            this.tracker.update(cost, complete, this.pOpt.isMinCost(cost));
        }
        return solution;
    }

    private SolutionCostPair<T> generate() {
        IncrementalEvaluation<T> incEval = this.heuristic.createIncrementalEvaluation();
        int n = this.heuristic.completeLength();
        Partial<T> p = this.heuristic.createPartial(n);
        while (!p.isComplete()) {
            int k = p.numExtensions();
            if (k == 1) {
                if (incEval != null) {
                    incEval.extend(p, p.getExtension(0));
                }
                p.extend(0);
                continue;
            }
            double bestH = Double.NEGATIVE_INFINITY;
            int which = 0;
            for (int i = 0; i < k; ++i) {
                double h = this.heuristic.h(p, p.getExtension(i), incEval);
                if (!(h > bestH)) continue;
                bestH = h;
                which = i;
            }
            if (incEval != null) {
                incEval.extend(p, p.getExtension(which));
            }
            p.extend(which);
        }
        T complete = p.toComplete();
        return this.evaluateAndPackageSolution(complete);
    }
}

