/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.ss;

import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.search.ProgressTracker;
import org.cicirello.search.SolutionCostPair;
import org.cicirello.search.ss.AbstractStochasticSampler;
import org.cicirello.search.ss.ConstructiveHeuristic;
import org.cicirello.search.ss.IncrementalEvaluation;
import org.cicirello.search.ss.Partial;
import org.cicirello.util.Copyable;

public final class AcceptanceBandSampling<T extends Copyable<T>>
extends AbstractStochasticSampler<T> {
    private final ConstructiveHeuristic<T> heuristic;
    private final double acceptancePercentage;

    public AcceptanceBandSampling(ConstructiveHeuristic<T> heuristic) {
        this(heuristic, 0.1, new ProgressTracker());
    }

    public AcceptanceBandSampling(ConstructiveHeuristic<T> heuristic, ProgressTracker<T> tracker) {
        this(heuristic, 0.1, tracker);
    }

    public AcceptanceBandSampling(ConstructiveHeuristic<T> heuristic, double beta) {
        this(heuristic, beta, new ProgressTracker());
    }

    public AcceptanceBandSampling(ConstructiveHeuristic<T> heuristic, double beta, ProgressTracker<T> tracker) {
        super(heuristic.getProblem(), tracker);
        this.heuristic = heuristic;
        if (beta < 0.0 || beta > 1.0) {
            throw new IllegalArgumentException("beta must be in the interval: [0.0, 1.0].");
        }
        this.acceptancePercentage = 1.0 - beta;
    }

    private AcceptanceBandSampling(AcceptanceBandSampling<T> other) {
        super(other);
        this.heuristic = other.heuristic;
        this.acceptancePercentage = other.acceptancePercentage;
    }

    @Override
    public AcceptanceBandSampling<T> split() {
        return new AcceptanceBandSampling<T>(this);
    }

    int choose(double[] values, int k, double max, int[] equivalents) {
        double threshold = max * this.acceptancePercentage;
        int n = 0;
        for (int i = 0; i < k; ++i) {
            if (!(values[i] >= threshold)) continue;
            equivalents[n] = i;
            ++n;
        }
        return equivalents[RandomIndexer.nextInt((int)n)];
    }

    @Override
    SolutionCostPair<T> sample() {
        IncrementalEvaluation<T> incEval = this.heuristic.createIncrementalEvaluation();
        int n = this.heuristic.completeLength();
        Partial<T> p = this.heuristic.createPartial(n);
        double[] v = new double[n];
        int[] equivalents = new int[n];
        while (!p.isComplete()) {
            int k = p.numExtensions();
            if (k == 1) {
                if (incEval != null) {
                    incEval.extend(p, p.getExtension(0));
                }
                p.extend(0);
                continue;
            }
            double max = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < k; ++i) {
                v[i] = this.heuristic.h(p, p.getExtension(i), incEval);
                if (!(v[i] > max)) continue;
                max = v[i];
            }
            int which = this.choose(v, k, max, equivalents);
            if (incEval != null) {
                incEval.extend(p, p.getExtension(which));
            }
            p.extend(which);
        }
        T complete = p.toComplete();
        return this.evaluateAndPackageSolution(complete);
    }
}

