/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.ss;

import org.cicirello.search.Metaheuristic;
import org.cicirello.search.ProgressTracker;
import org.cicirello.search.SimpleMetaheuristic;
import org.cicirello.search.SolutionCostPair;
import org.cicirello.search.problems.IntegerCostOptimizationProblem;
import org.cicirello.search.problems.OptimizationProblem;
import org.cicirello.search.problems.Problem;
import org.cicirello.util.Copyable;

abstract class AbstractStochasticSampler<T extends Copyable<T>>
implements SimpleMetaheuristic<T>,
Metaheuristic<T> {
    final OptimizationProblem<T> pOpt;
    final IntegerCostOptimizationProblem<T> pOptInt;
    ProgressTracker<T> tracker;
    private int numGenerated;

    AbstractStochasticSampler(Problem<T> problem, ProgressTracker<T> tracker) {
        if (problem == null || tracker == null) {
            throw new NullPointerException();
        }
        this.tracker = tracker;
        if (problem instanceof IntegerCostOptimizationProblem) {
            this.pOptInt = (IntegerCostOptimizationProblem)problem;
            this.pOpt = null;
        } else {
            this.pOpt = (OptimizationProblem)problem;
            this.pOptInt = null;
        }
    }

    AbstractStochasticSampler(AbstractStochasticSampler<T> other) {
        this.pOpt = other.pOpt;
        this.pOptInt = other.pOptInt;
        this.tracker = other.tracker;
    }

    @Override
    public final SolutionCostPair<T> optimize() {
        if (this.tracker.didFindBest() || this.tracker.isStopped()) {
            return null;
        }
        ++this.numGenerated;
        return this.sample();
    }

    @Override
    public final SolutionCostPair<T> optimize(int numSamples) {
        if (this.tracker.didFindBest() || this.tracker.isStopped()) {
            return null;
        }
        SolutionCostPair<T> best = null;
        for (int i = 0; i < numSamples && !this.tracker.didFindBest() && !this.tracker.isStopped(); ++i) {
            SolutionCostPair<T> current = this.sample();
            ++this.numGenerated;
            if (best != null && current.compareTo(best) >= 0) continue;
            best = current;
        }
        return best;
    }

    @Override
    public final ProgressTracker<T> getProgressTracker() {
        return this.tracker;
    }

    @Override
    public final void setProgressTracker(ProgressTracker<T> tracker) {
        if (tracker != null) {
            this.tracker = tracker;
        }
    }

    @Override
    public final long getTotalRunLength() {
        return this.numGenerated;
    }

    @Override
    public final Problem<T> getProblem() {
        return this.pOptInt != null ? this.pOptInt : this.pOpt;
    }

    @Override
    public abstract AbstractStochasticSampler<T> split();

    final int select(double[] values, int k, double u) {
        int first = 0;
        int last = k - 1;
        while (first < last) {
            int mid = first + last >> 1;
            if (u < values[mid]) {
                last = mid;
                continue;
            }
            first = mid + 1;
        }
        return first;
    }

    SolutionCostPair<T> evaluateAndPackageSolution(T complete) {
        if (this.pOptInt != null) {
            int cost = this.pOptInt.cost(complete);
            boolean isMinCost = this.pOptInt.isMinCost(cost);
            if (cost < this.tracker.getCost()) {
                this.tracker.update(cost, complete, isMinCost);
            }
            return new SolutionCostPair<T>(complete, cost, isMinCost);
        }
        double cost = this.pOpt.cost(complete);
        boolean isMinCost = this.pOpt.isMinCost(cost);
        if (cost < this.tracker.getCostDouble()) {
            this.tracker.update(cost, complete, isMinCost);
        }
        return new SolutionCostPair<T>(complete, cost, isMinCost);
    }

    abstract SolutionCostPair<T> sample();
}

