/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.sa;

import org.cicirello.search.ProgressTracker;
import org.cicirello.search.SimpleLocalMetaheuristic;
import org.cicirello.search.SingleSolutionMetaheuristic;
import org.cicirello.search.SolutionCostPair;
import org.cicirello.search.operators.Initializer;
import org.cicirello.search.operators.UndoableMutationOperator;
import org.cicirello.search.problems.IntegerCostOptimizationProblem;
import org.cicirello.search.problems.OptimizationProblem;
import org.cicirello.search.problems.Problem;
import org.cicirello.search.sa.AnnealingSchedule;
import org.cicirello.search.sa.SelfTuningLam;
import org.cicirello.util.Copyable;

public class SimulatedAnnealing<T extends Copyable<T>>
implements SingleSolutionMetaheuristic<T> {
    private final SimpleLocalMetaheuristic<T> hc;
    private final IntegerCostOptimizationProblem<T> pOptInt;
    private final OptimizationProblem<T> pOpt;
    private final Initializer<T> initializer;
    private final UndoableMutationOperator<T> mutation;
    private final AnnealingSchedule anneal;
    private int elapsedEvals;
    private ProgressTracker<T> tracker;
    private final SingleRun<T> sr;

    public SimulatedAnnealing(IntegerCostOptimizationProblem<T> problem, UndoableMutationOperator<T> mutation, Initializer<T> initializer, AnnealingSchedule anneal, ProgressTracker<T> tracker) {
        this(problem, mutation, initializer, anneal, tracker, null);
    }

    public SimulatedAnnealing(OptimizationProblem<T> problem, UndoableMutationOperator<T> mutation, Initializer<T> initializer, AnnealingSchedule anneal, ProgressTracker<T> tracker) {
        this(problem, mutation, initializer, anneal, tracker, null);
    }

    public SimulatedAnnealing(OptimizationProblem<T> problem, UndoableMutationOperator<T> mutation, Initializer<T> initializer, AnnealingSchedule anneal, ProgressTracker<T> tracker, SimpleLocalMetaheuristic<T> hc) {
        if (problem == null || mutation == null || anneal == null || initializer == null || tracker == null) {
            throw new NullPointerException();
        }
        this.initializer = initializer;
        this.mutation = mutation;
        this.anneal = anneal;
        this.tracker = tracker;
        this.pOpt = problem;
        this.pOptInt = null;
        this.sr = this.initSingleRunDouble();
        this.hc = hc;
        if (hc != null) {
            if (problem != hc.getProblem()) {
                throw new IllegalArgumentException("hc must be configured with the same problem.");
            }
            if (hc.getProgressTracker() != tracker) {
                hc.setProgressTracker(tracker);
            }
        }
    }

    public SimulatedAnnealing(IntegerCostOptimizationProblem<T> problem, UndoableMutationOperator<T> mutation, Initializer<T> initializer, AnnealingSchedule anneal, ProgressTracker<T> tracker, SimpleLocalMetaheuristic<T> hc) {
        if (problem == null || mutation == null || anneal == null || initializer == null || tracker == null) {
            throw new NullPointerException();
        }
        this.initializer = initializer;
        this.mutation = mutation;
        this.anneal = anneal;
        this.tracker = tracker;
        this.pOptInt = problem;
        this.pOpt = null;
        this.sr = this.initSingleRunInt();
        this.hc = hc;
        if (hc != null) {
            if (problem != hc.getProblem()) {
                throw new IllegalArgumentException("hc must be configured with the same problem.");
            }
            if (hc.getProgressTracker() != tracker) {
                hc.setProgressTracker(tracker);
            }
        }
    }

    public SimulatedAnnealing(OptimizationProblem<T> problem, UndoableMutationOperator<T> mutation, Initializer<T> initializer, ProgressTracker<T> tracker) {
        this(problem, mutation, initializer, (AnnealingSchedule)new SelfTuningLam(), tracker, null);
    }

    public SimulatedAnnealing(IntegerCostOptimizationProblem<T> problem, UndoableMutationOperator<T> mutation, Initializer<T> initializer, ProgressTracker<T> tracker) {
        this(problem, mutation, initializer, (AnnealingSchedule)new SelfTuningLam(), tracker, null);
    }

    public SimulatedAnnealing(OptimizationProblem<T> problem, UndoableMutationOperator<T> mutation, Initializer<T> initializer, ProgressTracker<T> tracker, SimpleLocalMetaheuristic<T> hc) {
        this(problem, mutation, initializer, (AnnealingSchedule)new SelfTuningLam(), tracker, hc);
    }

    public SimulatedAnnealing(IntegerCostOptimizationProblem<T> problem, UndoableMutationOperator<T> mutation, Initializer<T> initializer, ProgressTracker<T> tracker, SimpleLocalMetaheuristic<T> hc) {
        this(problem, mutation, initializer, (AnnealingSchedule)new SelfTuningLam(), tracker, hc);
    }

    public SimulatedAnnealing(OptimizationProblem<T> problem, UndoableMutationOperator<T> mutation, Initializer<T> initializer, AnnealingSchedule anneal) {
        this(problem, mutation, initializer, anneal, new ProgressTracker(), null);
    }

    public SimulatedAnnealing(IntegerCostOptimizationProblem<T> problem, UndoableMutationOperator<T> mutation, Initializer<T> initializer, AnnealingSchedule anneal) {
        this(problem, mutation, initializer, anneal, new ProgressTracker(), null);
    }

    public SimulatedAnnealing(OptimizationProblem<T> problem, UndoableMutationOperator<T> mutation, Initializer<T> initializer, AnnealingSchedule anneal, SimpleLocalMetaheuristic<T> hc) {
        this(problem, mutation, initializer, anneal, new ProgressTracker(), hc);
    }

    public SimulatedAnnealing(IntegerCostOptimizationProblem<T> problem, UndoableMutationOperator<T> mutation, Initializer<T> initializer, AnnealingSchedule anneal, SimpleLocalMetaheuristic<T> hc) {
        this(problem, mutation, initializer, anneal, new ProgressTracker(), hc);
    }

    public SimulatedAnnealing(OptimizationProblem<T> problem, UndoableMutationOperator<T> mutation, Initializer<T> initializer) {
        this(problem, mutation, initializer, (AnnealingSchedule)new SelfTuningLam(), new ProgressTracker(), null);
    }

    public SimulatedAnnealing(IntegerCostOptimizationProblem<T> problem, UndoableMutationOperator<T> mutation, Initializer<T> initializer) {
        this(problem, mutation, initializer, (AnnealingSchedule)new SelfTuningLam(), new ProgressTracker(), null);
    }

    public SimulatedAnnealing(OptimizationProblem<T> problem, UndoableMutationOperator<T> mutation, Initializer<T> initializer, SimpleLocalMetaheuristic<T> hc) {
        this(problem, mutation, initializer, (AnnealingSchedule)new SelfTuningLam(), new ProgressTracker(), hc);
    }

    public SimulatedAnnealing(IntegerCostOptimizationProblem<T> problem, UndoableMutationOperator<T> mutation, Initializer<T> initializer, SimpleLocalMetaheuristic<T> hc) {
        this(problem, mutation, initializer, (AnnealingSchedule)new SelfTuningLam(), new ProgressTracker(), hc);
    }

    private SimulatedAnnealing(SimulatedAnnealing<T> other) {
        this.pOpt = other.pOpt;
        this.pOptInt = other.pOptInt;
        this.tracker = other.tracker;
        this.initializer = (Initializer)other.initializer.split();
        this.mutation = other.mutation.split();
        this.anneal = (AnnealingSchedule)other.anneal.split();
        this.hc = other.hc != null ? other.hc.split() : null;
        this.sr = this.pOptInt != null ? this.initSingleRunInt() : this.initSingleRunDouble();
    }

    @Override
    public final SolutionCostPair<T> reoptimize(int maxEvals) {
        if (this.tracker.didFindBest() || this.tracker.isStopped()) {
            return null;
        }
        Object start = this.tracker.getSolution();
        start = start == null ? (Copyable)this.initializer.createCandidateSolution() : start.copy();
        return this.sr.optimizeSingleRun(maxEvals, start);
    }

    @Override
    public final SolutionCostPair<T> optimize(int maxEvals) {
        if (this.tracker.didFindBest() || this.tracker.isStopped()) {
            return null;
        }
        return this.sr.optimizeSingleRun(maxEvals, (Copyable)this.initializer.createCandidateSolution());
    }

    @Override
    public final SolutionCostPair<T> optimize(int maxEvals, T start) {
        if (this.tracker.didFindBest() || this.tracker.isStopped()) {
            return null;
        }
        return this.sr.optimizeSingleRun(maxEvals, start.copy());
    }

    @Override
    public final Problem<T> getProblem() {
        return this.pOptInt != null ? this.pOptInt : this.pOpt;
    }

    @Override
    public final ProgressTracker<T> getProgressTracker() {
        return this.tracker;
    }

    @Override
    public final void setProgressTracker(ProgressTracker<T> tracker) {
        if (tracker != null) {
            this.tracker = tracker;
        }
    }

    @Override
    public SimulatedAnnealing<T> split() {
        return new SimulatedAnnealing<T>(this);
    }

    @Override
    public long getTotalRunLength() {
        if (this.hc == null) {
            return this.elapsedEvals;
        }
        return (long)this.elapsedEvals + this.hc.getTotalRunLength();
    }

    private SingleRun<T> initSingleRunInt() {
        return (maxEvals, current) -> {
            int bestCost;
            int currentCost = this.pOptInt.cost(current);
            if (currentCost < (bestCost = this.tracker.getCost())) {
                boolean isMinCost = this.pOptInt.isMinCost(currentCost);
                bestCost = this.tracker.update(currentCost, current, isMinCost);
                if (this.tracker.didFindBest()) {
                    return new SolutionCostPair<Copyable>(current, currentCost, isMinCost);
                }
            }
            this.anneal.init(maxEvals);
            for (int i = 1; i <= maxEvals; ++i) {
                if (this.tracker.isStopped()) {
                    this.elapsedEvals += i - 1;
                    return new SolutionCostPair<Copyable>(current, currentCost, this.pOptInt.isMinCost(currentCost));
                }
                this.mutation.mutate(current);
                int neighborCost = this.pOptInt.cost(current);
                if (this.anneal.accept(neighborCost, currentCost)) {
                    currentCost = neighborCost;
                    if (currentCost >= bestCost) continue;
                    boolean isMinCost = this.pOptInt.isMinCost(currentCost);
                    bestCost = this.tracker.update(currentCost, current, isMinCost);
                    if (!this.tracker.didFindBest()) continue;
                    this.elapsedEvals += i;
                    return new SolutionCostPair<Copyable>(current, currentCost, isMinCost);
                }
                this.mutation.undo(current);
            }
            this.elapsedEvals += maxEvals;
            return this.hc == null ? new SolutionCostPair<Copyable>(current, currentCost, this.pOptInt.isMinCost(currentCost)) : this.hc.optimize(current);
        };
    }

    private SingleRun<T> initSingleRunDouble() {
        return (maxEvals, current) -> {
            double bestCost;
            double currentCost = this.pOpt.cost(current);
            if (currentCost < (bestCost = this.tracker.getCostDouble())) {
                boolean isMinCost = this.pOpt.isMinCost(currentCost);
                bestCost = this.tracker.update(currentCost, current, isMinCost);
                if (this.tracker.didFindBest()) {
                    return new SolutionCostPair<Copyable>(current, currentCost, isMinCost);
                }
            }
            this.anneal.init(maxEvals);
            for (int i = 1; i <= maxEvals; ++i) {
                if (this.tracker.isStopped()) {
                    this.elapsedEvals += i - 1;
                    return new SolutionCostPair<Copyable>(current, currentCost, this.pOpt.isMinCost(currentCost));
                }
                this.mutation.mutate(current);
                double neighborCost = this.pOpt.cost(current);
                if (this.anneal.accept(neighborCost, currentCost)) {
                    currentCost = neighborCost;
                    if (!(currentCost < bestCost)) continue;
                    boolean isMinCost = this.pOpt.isMinCost(currentCost);
                    bestCost = this.tracker.update(currentCost, current, isMinCost);
                    if (!this.tracker.didFindBest()) continue;
                    this.elapsedEvals += i;
                    return new SolutionCostPair<Copyable>(current, currentCost, isMinCost);
                }
                this.mutation.undo(current);
            }
            this.elapsedEvals += maxEvals;
            return this.hc == null ? new SolutionCostPair<Copyable>(current, currentCost, this.pOpt.isMinCost(currentCost)) : this.hc.optimize(current);
        };
    }

    private static interface SingleRun<T extends Copyable<T>> {
        public SolutionCostPair<T> optimizeSingleRun(int var1, T var2);
    }
}

