/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.sa;

import java.util.concurrent.ThreadLocalRandom;
import org.cicirello.search.sa.AnnealingSchedule;

public final class ParameterFreeLinearCooling
implements AnnealingSchedule {
    private double t;
    private double deltaT;
    private int steps;
    private int stepCounter;
    private static final int ESTIMATION_SAMPLE_SIZE = 10;
    private static final double LOG_INITIAL_ACCEPTANCE_PROBABILITY = Math.log(0.95);
    private double costSum;
    private int maxEvals;
    private int numEstSamples;

    @Override
    public void init(int maxEvals) {
        this.maxEvals = maxEvals;
        this.costSum = 0.0;
        this.stepCounter = 0;
        this.numEstSamples = 0;
        this.t = 0.0;
        this.steps = 0;
        this.deltaT = 0.0;
    }

    @Override
    public boolean accept(double neighborCost, double currentCost) {
        if (this.numEstSamples < 10) {
            this.estimationStep(neighborCost, currentCost);
            return true;
        }
        boolean doAccept = neighborCost <= currentCost || ThreadLocalRandom.current().nextDouble() < Math.exp((currentCost - neighborCost) / this.t);
        ++this.stepCounter;
        if (this.stepCounter == this.steps && this.t > 0.001) {
            this.stepCounter = 0;
            this.t -= this.deltaT;
            if (this.t < 0.001) {
                this.t = 0.001;
            }
        }
        return doAccept;
    }

    @Override
    public ParameterFreeLinearCooling split() {
        return new ParameterFreeLinearCooling();
    }

    private void estimationStep(double neighborCost, double currentCost) {
        ++this.stepCounter;
        if (neighborCost != currentCost) {
            ++this.numEstSamples;
            this.costSum -= Math.abs(neighborCost - currentCost);
            if (this.numEstSamples == 10) {
                this.t = this.costSum / (10.0 * LOG_INITIAL_ACCEPTANCE_PROBABILITY);
                if (this.t < 0.002) {
                    this.t = 0.002;
                }
                int i = 0;
                int j = 0;
                double drop = this.t - 0.001;
                int remaining = this.maxEvals - this.stepCounter - 1;
                do {
                    int k = (remaining & j) == 0 ? remaining >> i : (remaining >> i) + 1;
                    this.deltaT = drop / (double)k;
                    ++i;
                    j = j << 1 | 1;
                } while (this.deltaT < 1.0E-6);
                this.steps = 1 << i - 1;
                this.stepCounter = 0;
            }
        }
    }

    double getTemperature() {
        return this.t;
    }

    double getDeltaT() {
        return this.deltaT;
    }

    int getSteps() {
        return this.steps;
    }
}

