/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.sa;

import java.util.concurrent.ThreadLocalRandom;
import org.cicirello.search.sa.AnnealingSchedule;

public final class ModifiedLamOriginal
implements AnnealingSchedule {
    private double t;
    private double acceptRate;
    private double targetRate;
    private double phase1;
    private double phase2;
    private int iterationCount;
    private int lastMaxEvals = -1;

    @Override
    public void init(int maxEvals) {
        this.t = 0.5;
        this.acceptRate = 0.5;
        this.targetRate = 1.0;
        this.iterationCount = 0;
        if (this.lastMaxEvals != maxEvals) {
            this.phase1 = 0.15 * (double)maxEvals;
            this.phase2 = 0.65 * (double)maxEvals;
            this.lastMaxEvals = maxEvals;
        }
    }

    @Override
    public boolean accept(double neighborCost, double currentCost) {
        boolean doAccept = neighborCost <= currentCost || ThreadLocalRandom.current().nextDouble() < Math.exp((currentCost - neighborCost) / this.t);
        this.updateSchedule(doAccept);
        return doAccept;
    }

    @Override
    public ModifiedLamOriginal split() {
        return new ModifiedLamOriginal();
    }

    private void updateSchedule(boolean doAccept) {
        this.acceptRate = doAccept ? 0.998 * this.acceptRate + 0.002 : 0.998 * this.acceptRate;
        ++this.iterationCount;
        this.targetRate = (double)this.iterationCount <= this.phase1 ? 0.44 + 0.56 * Math.pow(560.0, -1.0 * (double)this.iterationCount / this.phase1) : ((double)this.iterationCount > this.phase2 ? 0.44 * Math.pow(440.0, -(1.0 * (double)this.iterationCount / (double)this.lastMaxEvals - 0.65) / 0.35) : 0.44);
        this.t = this.acceptRate > this.targetRate ? (this.t *= 0.999) : (this.t /= 0.999);
    }

    double getTargetRate() {
        return this.targetRate;
    }

    double getAcceptRate() {
        return this.acceptRate;
    }

    double getTemperature() {
        return this.t;
    }
}

