/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.sa;

import java.util.concurrent.ThreadLocalRandom;
import org.cicirello.search.sa.AnnealingSchedule;

public final class LogarithmicCooling
implements AnnealingSchedule {
    private double t;
    private final double c;
    private int stepCounter;

    public LogarithmicCooling(double t0) {
        if (t0 <= 0.0) {
            throw new IllegalArgumentException("initial temperature must be positive");
        }
        this.t = this.c = t0;
    }

    private LogarithmicCooling(LogarithmicCooling other) {
        this.t = this.c = other.c;
    }

    @Override
    public void init(int maxEvals) {
        this.stepCounter = 0;
        this.t = this.c;
    }

    @Override
    public boolean accept(double neighborCost, double currentCost) {
        boolean doAccept = neighborCost <= currentCost || ThreadLocalRandom.current().nextDouble() < Math.exp((currentCost - neighborCost) / this.t);
        ++this.stepCounter;
        this.t = this.c / StrictMath.log(Math.E + (double)this.stepCounter);
        return doAccept;
    }

    @Override
    public LogarithmicCooling split() {
        return new LogarithmicCooling(this);
    }

    double getTemperature() {
        return this.t;
    }
}

