/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.sa;

import java.util.concurrent.ThreadLocalRandom;
import org.cicirello.search.sa.AnnealingSchedule;

public final class LinearCooling
implements AnnealingSchedule {
    private double t;
    private final double t0;
    private final double deltaT;
    private final int steps;
    private int stepCounter;

    public LinearCooling(double t0, double deltaT, int steps) {
        if (t0 <= 0.0) {
            throw new IllegalArgumentException("Initial temperature must be positive");
        }
        if (deltaT <= 0.0) {
            throw new IllegalArgumentException("deltaT must be positive");
        }
        this.t = this.t0 = t0;
        this.deltaT = deltaT;
        this.steps = steps <= 0 ? 1 : steps;
    }

    public LinearCooling(double t0, double deltaT) {
        if (t0 <= 0.0) {
            throw new IllegalArgumentException("Initial temperature must be positive");
        }
        if (deltaT <= 0.0) {
            throw new IllegalArgumentException("deltaT must be positive");
        }
        this.t = this.t0 = t0;
        this.deltaT = deltaT;
        this.steps = 1;
    }

    private LinearCooling(LinearCooling other) {
        this.t = this.t0 = other.t0;
        this.deltaT = other.deltaT;
        this.steps = other.steps;
    }

    @Override
    public void init(int maxEvals) {
        this.t = this.t0;
        this.stepCounter = 0;
    }

    @Override
    public boolean accept(double neighborCost, double currentCost) {
        boolean doAccept = neighborCost <= currentCost || ThreadLocalRandom.current().nextDouble() < Math.exp((currentCost - neighborCost) / this.t);
        ++this.stepCounter;
        if (this.stepCounter == this.steps && this.t > 0.001) {
            this.stepCounter = 0;
            this.t -= this.deltaT;
            if (this.t < 0.001) {
                this.t = 0.001;
            }
        }
        return doAccept;
    }

    @Override
    public LinearCooling split() {
        return new LinearCooling(this);
    }

    double getTemperature() {
        return this.t;
    }
}

