/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.sa;

import java.util.concurrent.ThreadLocalRandom;
import org.cicirello.search.sa.AnnealingSchedule;

public final class ExponentialCooling
implements AnnealingSchedule {
    private double t;
    private final double t0;
    private final double alpha;
    private final int steps;
    private int stepCounter;

    public ExponentialCooling(double t0, double alpha, int steps) {
        if (t0 <= 0.0) {
            throw new IllegalArgumentException("Initial temperature must be positive");
        }
        if (alpha <= 0.0 || alpha >= 1.0) {
            throw new IllegalArgumentException("alpha must be in interval (0,1)");
        }
        this.t = this.t0 = t0;
        this.alpha = alpha;
        this.steps = steps <= 0 ? 1 : steps;
    }

    public ExponentialCooling(double t0, double alpha) {
        if (t0 <= 0.0) {
            throw new IllegalArgumentException("Initial temperature must be positive");
        }
        if (alpha <= 0.0 || alpha >= 1.0) {
            throw new IllegalArgumentException("alpha must be in interval (0,1)");
        }
        this.t = this.t0 = t0;
        this.alpha = alpha;
        this.steps = 1;
    }

    private ExponentialCooling(ExponentialCooling other) {
        this.t = this.t0 = other.t0;
        this.alpha = other.alpha;
        this.steps = other.steps;
    }

    @Override
    public void init(int maxEvals) {
        this.t = this.t0;
        this.stepCounter = 0;
    }

    @Override
    public boolean accept(double neighborCost, double currentCost) {
        boolean doAccept = neighborCost <= currentCost || ThreadLocalRandom.current().nextDouble() < Math.exp((currentCost - neighborCost) / this.t);
        ++this.stepCounter;
        if (this.stepCounter == this.steps && this.t > 0.001) {
            this.stepCounter = 0;
            this.t *= this.alpha;
        }
        return doAccept;
    }

    @Override
    public ExponentialCooling split() {
        return new ExponentialCooling(this);
    }

    double getTemperature() {
        return this.t;
    }
}

