/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.restarts;

import java.util.ArrayList;
import java.util.List;
import org.cicirello.search.restarts.RestartSchedule;

public final class VariableAnnealingLength
implements RestartSchedule {
    private final int r0;
    private int r;

    public VariableAnnealingLength() {
        this.r0 = 1000;
        this.r = 1000;
    }

    public VariableAnnealingLength(int r0) {
        if (r0 < 1) {
            throw new IllegalArgumentException("r0 must be positive");
        }
        this.r = this.r0 = r0;
    }

    @Override
    public int nextRunLength() {
        int next = this.r;
        this.r = this.r < 0x40000000 ? (this.r <<= 1) : Integer.MAX_VALUE;
        return next;
    }

    @Override
    public void reset() {
        this.r = this.r0;
    }

    @Override
    public VariableAnnealingLength split() {
        return new VariableAnnealingLength(this.r0);
    }

    public static List<VariableAnnealingLength> createRestartSchedules(int numThreads) {
        return VariableAnnealingLength.createRestartSchedules(numThreads, 1000);
    }

    public static List<VariableAnnealingLength> createRestartSchedules(int numThreads, int r0) {
        if (numThreads <= 0) {
            throw new IllegalArgumentException("Must have at least 1 thread.");
        }
        if (r0 <= 0) {
            throw new IllegalArgumentException("r0 must be greater than 0");
        }
        ArrayList<VariableAnnealingLength> schedules = new ArrayList<VariableAnnealingLength>(numThreads);
        for (int i = 0; i < numThreads; ++i) {
            schedules.add(new VariableAnnealingLength(r0));
        }
        return schedules;
    }
}

