/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.restarts;

import org.cicirello.search.Metaheuristic;
import org.cicirello.search.ProgressTracker;
import org.cicirello.search.SolutionCostPair;
import org.cicirello.search.problems.Problem;
import org.cicirello.search.restarts.ConstantRestartSchedule;
import org.cicirello.search.restarts.RestartSchedule;
import org.cicirello.util.Copyable;

public class Multistarter<T extends Copyable<T>>
implements Metaheuristic<T> {
    private final Metaheuristic<T> search;
    final RestartSchedule r;

    public Multistarter(Metaheuristic<T> search, RestartSchedule r) {
        this.search = search;
        this.r = r;
    }

    public Multistarter(Metaheuristic<T> search, int runLength) {
        this(search, new ConstantRestartSchedule(runLength));
    }

    @Override
    public final ProgressTracker<T> getProgressTracker() {
        return this.search.getProgressTracker();
    }

    @Override
    public final void setProgressTracker(ProgressTracker<T> tracker) {
        if (tracker != null) {
            this.search.setProgressTracker(tracker);
        }
    }

    @Override
    public final Problem<T> getProblem() {
        return this.search.getProblem();
    }

    @Override
    public final long getTotalRunLength() {
        return this.search.getTotalRunLength();
    }

    @Override
    public final SolutionCostPair<T> optimize(int numRestarts) {
        ProgressTracker tracker = this.search.getProgressTracker();
        SolutionCostPair<T> bestRestart = null;
        for (int i = 0; i < numRestarts && !tracker.isStopped() && !tracker.didFindBest(); ++i) {
            SolutionCostPair<T> thisRestart = this.search.optimize(this.r.nextRunLength());
            if (bestRestart != null && (thisRestart == null || thisRestart.compareTo(bestRestart) >= 0)) continue;
            bestRestart = thisRestart;
        }
        return bestRestart;
    }

    @Override
    public Multistarter<T> split() {
        return new Multistarter<T>(this.search.split(), (RestartSchedule)this.r.split());
    }
}

