/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.restarts;

import java.util.ArrayList;
import java.util.List;
import org.cicirello.search.restarts.RestartSchedule;

public final class ConstantRestartSchedule
implements RestartSchedule {
    private final int r;

    public ConstantRestartSchedule(int runLength) {
        if (runLength < 1) {
            throw new IllegalArgumentException("runLength must be positive");
        }
        this.r = runLength;
    }

    public static List<ConstantRestartSchedule> createRestartSchedules(int numThreads, int runLength) {
        if (runLength < 1) {
            throw new IllegalArgumentException("runLength must be positive");
        }
        if (numThreads <= 0) {
            throw new IllegalArgumentException("Must have at least 1 thread.");
        }
        ArrayList<ConstantRestartSchedule> schedules = new ArrayList<ConstantRestartSchedule>(numThreads);
        schedules.add(new ConstantRestartSchedule(runLength));
        for (int i = 1; i < numThreads; ++i) {
            schedules.add(schedules.get(0).split());
        }
        return schedules;
    }

    @Override
    public int nextRunLength() {
        return this.r;
    }

    @Override
    public void reset() {
    }

    @Override
    public ConstantRestartSchedule split() {
        return this;
    }
}

