/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.representations;

import java.util.Arrays;
import org.cicirello.search.representations.BoundedRealVector;
import org.cicirello.search.representations.RealValued;
import org.cicirello.util.Copyable;

public class RealVector
implements RealValued,
Copyable<RealVector> {
    private final double[] x;

    public RealVector(int n) {
        this.x = new double[n];
    }

    public RealVector(double[] x) {
        this.x = (double[])x.clone();
    }

    public RealVector(RealVector other) {
        this.x = (double[])other.x.clone();
    }

    @Override
    public final int length() {
        return this.x.length;
    }

    @Override
    public final double get(int i) {
        return this.x[i];
    }

    @Override
    public final double[] toArray(double[] values) {
        if (values == null || values.length != this.x.length) {
            return (double[])this.x.clone();
        }
        System.arraycopy(this.x, 0, values, 0, values.length);
        return values;
    }

    @Override
    public void set(int i, double value) {
        this.x[i] = value;
    }

    public static void exchange(RealVector v1, RealVector v2, int firstIndex, int lastIndex) {
        if (firstIndex > lastIndex) {
            int temp = firstIndex;
            firstIndex = lastIndex;
            lastIndex = temp;
        }
        if (RealVector.canSimpleExchange(v1, v2)) {
            int N = lastIndex - firstIndex + 1;
            double[] temp = new double[N];
            System.arraycopy(v1.x, firstIndex, temp, 0, N);
            System.arraycopy(v2.x, firstIndex, v1.x, firstIndex, N);
            System.arraycopy(temp, 0, v2.x, firstIndex, N);
        } else {
            for (int i = firstIndex; i <= lastIndex; ++i) {
                double temp = v1.x[i];
                v1.set(i, v2.x[i]);
                v2.set(i, temp);
            }
        }
    }

    private static boolean canSimpleExchange(RealVector v1, RealVector v2) {
        if (v1 instanceof BoundedRealVector) {
            return v2 instanceof BoundedRealVector && ((BoundedRealVector)v1).sameBounds((BoundedRealVector)v2);
        }
        return !(v2 instanceof BoundedRealVector);
    }

    public RealVector copy() {
        return new RealVector(this);
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof RealVector)) {
            return false;
        }
        return Arrays.equals(this.x, ((RealVector)other).x);
    }

    public int hashCode() {
        return Arrays.hashCode(this.x);
    }
}

