/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.representations;

import org.cicirello.search.representations.RealVector;

public final class BoundedRealVector
extends RealVector {
    private final double min;
    private final double max;

    public BoundedRealVector(double[] x, double min, double max) {
        super(x.length);
        if (min > max) {
            throw new IllegalArgumentException("max must be greater than or equal to min");
        }
        this.min = min;
        this.max = max;
        for (int i = 0; i < x.length; ++i) {
            this.set(i, x[i]);
        }
    }

    public BoundedRealVector(BoundedRealVector other) {
        super(other);
        this.min = other.min;
        this.max = other.max;
    }

    @Override
    public final void set(int i, double value) {
        if (value < this.min) {
            super.set(i, this.min);
        } else if (value > this.max) {
            super.set(i, this.max);
        } else {
            super.set(i, value);
        }
    }

    public final boolean sameBounds(BoundedRealVector other) {
        return this.min == other.min && this.max == other.max;
    }

    @Override
    public BoundedRealVector copy() {
        return new BoundedRealVector(this);
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other) || !(other instanceof BoundedRealVector)) {
            return false;
        }
        return this.sameBounds((BoundedRealVector)other);
    }

    @Override
    public int hashCode() {
        return 31 * (31 * (31 + Double.hashCode(this.min)) + Double.hashCode(this.max)) + super.hashCode();
    }
}

