/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.representations;

import org.cicirello.search.representations.IntegerVector;

public final class BoundedIntegerVector
extends IntegerVector {
    private final int min;
    private final int max;

    public BoundedIntegerVector(int[] x, int min, int max) {
        super(x.length);
        if (min > max) {
            throw new IllegalArgumentException("max must be greater than or equal to min");
        }
        this.min = min;
        this.max = max;
        for (int i = 0; i < x.length; ++i) {
            this.set(i, x[i]);
        }
    }

    public BoundedIntegerVector(BoundedIntegerVector other) {
        super(other);
        this.min = other.min;
        this.max = other.max;
    }

    @Override
    public final void set(int i, int value) {
        if (value < this.min) {
            super.set(i, this.min);
        } else if (value > this.max) {
            super.set(i, this.max);
        } else {
            super.set(i, value);
        }
    }

    public final boolean sameBounds(BoundedIntegerVector other) {
        return this.min == other.min && this.max == other.max;
    }

    @Override
    public BoundedIntegerVector copy() {
        return new BoundedIntegerVector(this);
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other) || !(other instanceof BoundedIntegerVector)) {
            return false;
        }
        return this.sameBounds((BoundedIntegerVector)other);
    }

    @Override
    public int hashCode() {
        int hash = 31 * (31 + this.min) + this.max;
        int L = this.length();
        for (int i = 0; i < L; ++i) {
            hash = 31 * hash + this.get(i);
        }
        return hash;
    }
}

