/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.problems.tsp;

import org.cicirello.permutations.Permutation;
import org.cicirello.search.problems.Problem;
import org.cicirello.search.problems.tsp.BaseTSP;
import org.cicirello.search.ss.ConstructiveHeuristic;
import org.cicirello.search.ss.IncrementalEvaluation;
import org.cicirello.search.ss.Partial;
import org.cicirello.search.ss.PartialPermutation;

public final class NearestCityPairHeuristic
implements ConstructiveHeuristic<Permutation> {
    private final BaseTSP problem;

    public NearestCityPairHeuristic(BaseTSP problem) {
        this.problem = problem;
    }

    @Override
    public double h(Partial<Permutation> p, int element, IncrementalEvaluation<Permutation> incEval) {
        NearestCityPairHeuristicIncrementalEvaluation evaluator = (NearestCityPairHeuristicIncrementalEvaluation)incEval;
        double denom = 1.0 + evaluator.distanceToNearestCity[element];
        if (p.size() > 0) {
            denom += this.problem.edgeCostForHeuristics(p.getLast(), element);
        }
        return 1.0 / denom;
    }

    @Override
    public IncrementalEvaluation<Permutation> createIncrementalEvaluation() {
        return new NearestCityPairHeuristicIncrementalEvaluation();
    }

    @Override
    public final Problem<Permutation> getProblem() {
        return this.problem;
    }

    @Override
    public final Partial<Permutation> createPartial(int n) {
        return new PartialPermutation(n);
    }

    @Override
    public final int completeLength() {
        return this.problem.length();
    }

    final class NearestCityPairHeuristicIncrementalEvaluation
    implements IncrementalEvaluation<Permutation> {
        final double[] distanceToNearestCity;
        final int[] nearestRemainingCity;
        private final int[] remainingCities;
        private int numRemaining;

        NearestCityPairHeuristicIncrementalEvaluation() {
            this.numRemaining = NearestCityPairHeuristic.this.problem.length();
            this.distanceToNearestCity = new double[this.numRemaining];
            this.nearestRemainingCity = new int[this.numRemaining];
            this.remainingCities = new int[this.numRemaining];
            for (int i = 0; i < this.numRemaining; ++i) {
                this.distanceToNearestCity[i] = Double.POSITIVE_INFINITY;
                this.remainingCities[i] = i;
                for (int j = 0; j < this.numRemaining; ++j) {
                    double d;
                    if (i == j || !((d = NearestCityPairHeuristic.this.problem.edgeCostForHeuristics(i, j)) < this.distanceToNearestCity[i])) continue;
                    this.distanceToNearestCity[i] = d;
                    this.nearestRemainingCity[i] = j;
                }
            }
        }

        @Override
        public void extend(Partial<Permutation> p, int element) {
            this.removeFromRemaining(element);
            if (this.numRemaining > 1) {
                for (int i = 0; i < this.numRemaining; ++i) {
                    int x = this.remainingCities[i];
                    if (this.nearestRemainingCity[x] != element) continue;
                    this.distanceToNearestCity[x] = Double.POSITIVE_INFINITY;
                    for (int j = 0; j < this.numRemaining; ++j) {
                        int y;
                        double d;
                        if (i == j || !((d = NearestCityPairHeuristic.this.problem.edgeCostForHeuristics(x, y = this.remainingCities[j])) < this.distanceToNearestCity[x])) continue;
                        this.distanceToNearestCity[x] = d;
                        this.nearestRemainingCity[x] = y;
                    }
                }
            } else {
                this.distanceToNearestCity[this.remainingCities[0]] = 0.0;
            }
        }

        private void removeFromRemaining(int element) {
            int i;
            for (i = 0; i < this.numRemaining && this.remainingCities[i] != element; ++i) {
            }
            if (this.remainingCities[i] == element) {
                ++i;
                while (i < this.numRemaining) {
                    this.remainingCities[i - 1] = this.remainingCities[i];
                    ++i;
                }
                --this.numRemaining;
            }
        }

        final int numRemaining() {
            return this.numRemaining;
        }
    }
}

