/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.problems.scheduling;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import java.util.SplittableRandom;
import java.util.random.RandomGenerator;
import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.permutations.Permutation;
import org.cicirello.search.problems.scheduling.SingleMachineSchedulingProblemData;

public final class WeightedStaticScheduling
implements SingleMachineSchedulingProblemData {
    public static final int MIN_PROCESS_TIME = 1;
    public static final int MAX_PROCESS_TIME = 100;
    public static final int MIN_WEIGHT = 1;
    public static final int MAX_WEIGHT = 10;
    private final int[] process;
    private final int[] duedates;
    private final int[] weights;
    private final int PROCESS_TIME_SPAN = 100;
    private final int WEIGHT_SPAN = 10;

    public WeightedStaticScheduling(int n, double rdd, double tf, long seed) {
        this(n, rdd, tf, new SplittableRandom(seed));
    }

    public WeightedStaticScheduling(int n, double rdd, double tf) {
        this(n, rdd, tf, new SplittableRandom());
    }

    public WeightedStaticScheduling(String filename, int n, int instanceNumber) throws FileNotFoundException {
        this(new InputStreamReader((InputStream)new FileInputStream(filename), StandardCharsets.UTF_8), n, instanceNumber);
    }

    private WeightedStaticScheduling(int n, double rdd, double tf, RandomGenerator rand) {
        if (n <= 0) {
            throw new IllegalArgumentException("n must be positive");
        }
        if (rdd <= 0.0 || rdd > 1.0) {
            throw new IllegalArgumentException("rdd must be in (0.0, 1.0]");
        }
        if (tf < 0.0 || tf > 1.0) {
            throw new IllegalArgumentException("tf must be in [0.0, 1.0]");
        }
        this.process = new int[n];
        this.duedates = new int[n];
        this.weights = new int[n];
        int totalProcessTime = 0;
        for (int i = 0; i < n; ++i) {
            this.process[i] = 1 + RandomIndexer.nextInt((int)100, (RandomGenerator)rand);
            totalProcessTime += this.process[i];
            this.weights[i] = 1 + RandomIndexer.nextInt((int)10, (RandomGenerator)rand);
        }
        double D_LOWER_BOUND = (double)totalProcessTime * (1.0 - tf - rdd / 2.0);
        double D_UPPER_BOUND = (double)totalProcessTime * (1.0 - tf + rdd / 2.0);
        for (int i = 0; i < n; ++i) {
            int d = (int)Math.round(rand.nextDouble(D_LOWER_BOUND, D_UPPER_BOUND));
            this.duedates[i] = d < 0 ? 0 : d;
        }
    }

    WeightedStaticScheduling(Readable file, int n, int instanceNumber) {
        try (Scanner in = new Scanner(file);){
            int i;
            int skipCount = instanceNumber * n * 3;
            for (i = 0; i < skipCount; ++i) {
                in.nextInt();
            }
            this.process = new int[n];
            for (i = 0; i < n; ++i) {
                this.process[i] = in.nextInt();
            }
            this.weights = new int[n];
            for (i = 0; i < n; ++i) {
                this.weights[i] = in.nextInt();
            }
            this.duedates = new int[n];
            for (i = 0; i < n; ++i) {
                this.duedates[i] = in.nextInt();
            }
        }
    }

    @Override
    public int[] getCompletionTimes(Permutation schedule) {
        if (schedule.length() != this.process.length) {
            throw new IllegalArgumentException("schedule is incorrect length");
        }
        int[] c = new int[this.process.length];
        int time = 0;
        for (int i = 0; i < c.length; ++i) {
            int j = schedule.get(i);
            c[j] = time += this.process[j];
        }
        return c;
    }

    @Override
    public int numberOfJobs() {
        return this.weights.length;
    }

    @Override
    public int getProcessingTime(int j) {
        return this.process[j];
    }

    @Override
    public int getDueDate(int j) {
        return this.duedates[j];
    }

    @Override
    public boolean hasDueDates() {
        return true;
    }

    @Override
    public int getWeight(int j) {
        return this.weights[j];
    }

    @Override
    public boolean hasWeights() {
        return true;
    }

    public void toFile(String filename) throws FileNotFoundException {
        PrintWriter out = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(filename), StandardCharsets.UTF_8), true);
        this.toFile(out);
        out.close();
    }

    void toFile(PrintWriter out) {
        int i;
        for (i = 0; i < this.process.length; ++i) {
            out.print(this.process[i]);
            if (i == this.process.length - 1) {
                out.println();
                continue;
            }
            out.print(" ");
        }
        for (i = 0; i < this.weights.length; ++i) {
            out.print(this.weights[i]);
            if (i == this.weights.length - 1) {
                out.println();
                continue;
            }
            out.print(" ");
        }
        for (i = 0; i < this.duedates.length; ++i) {
            out.print(this.duedates[i]);
            if (i == this.duedates.length - 1) {
                out.println();
                continue;
            }
            out.print(" ");
        }
    }
}

