/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.problems.scheduling;

import org.cicirello.permutations.Permutation;
import org.cicirello.search.problems.scheduling.SchedulingHeuristic;
import org.cicirello.search.problems.scheduling.SingleMachineSchedulingProblem;
import org.cicirello.search.ss.IncrementalEvaluation;
import org.cicirello.search.ss.Partial;

public class WeightedShortestProcessingPlusSetupTime
extends SchedulingHeuristic {
    public WeightedShortestProcessingPlusSetupTime(SingleMachineSchedulingProblem problem) {
        super(problem);
    }

    @Override
    public double h(Partial<Permutation> p, int element, IncrementalEvaluation<Permutation> incEval) {
        double value = this.data.getWeight(element);
        if (value < 1.0E-5) {
            return 1.0E-5;
        }
        double denominator = this.data.getProcessingTime(element);
        if (this.HAS_SETUPS) {
            denominator += (double)(p.size() == 0 ? this.data.getSetupTime(element) : this.data.getSetupTime(p.getLast(), element));
        }
        return (value /= denominator) <= 1.0E-5 ? 1.0E-5 : value;
    }
}

