/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.problems.scheduling;

import org.cicirello.permutations.Permutation;
import org.cicirello.search.problems.scheduling.SingleMachineSchedulingProblem;
import org.cicirello.search.problems.scheduling.SingleMachineSchedulingProblemData;

public final class WeightedEarlinessTardiness
implements SingleMachineSchedulingProblem {
    private final SingleMachineSchedulingProblemData instanceData;

    public WeightedEarlinessTardiness(SingleMachineSchedulingProblemData instanceData) {
        this.instanceData = instanceData;
        if (!instanceData.hasDueDates()) {
            throw new IllegalArgumentException("This cost function requires due dates.");
        }
    }

    @Override
    public SingleMachineSchedulingProblemData getInstanceData() {
        return this.instanceData;
    }

    @Override
    public int cost(Permutation candidate) {
        int[] c = this.instanceData.getCompletionTimes(candidate);
        int total = 0;
        for (int i = 0; i < c.length; ++i) {
            int lateness = c[i] - this.instanceData.getDueDate(i);
            if (lateness > 0) {
                total += this.instanceData.getWeight(i) * lateness;
                continue;
            }
            if (lateness >= 0) continue;
            total -= this.instanceData.getEarlyWeight(i) * lateness;
        }
        return total;
    }

    @Override
    public int value(Permutation candidate) {
        return this.cost(candidate);
    }

    @Override
    public int minCost() {
        return 0;
    }
}

