/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.problems.scheduling;

import org.cicirello.permutations.Permutation;
import org.cicirello.search.problems.scheduling.SchedulingHeuristic;
import org.cicirello.search.problems.scheduling.SingleMachineSchedulingProblem;
import org.cicirello.search.ss.IncrementalEvaluation;
import org.cicirello.search.ss.Partial;

public final class SmallestTwoJobSetup
extends SchedulingHeuristic {
    public SmallestTwoJobSetup(SingleMachineSchedulingProblem problem) {
        super(problem);
    }

    @Override
    public double h(Partial<Permutation> p, int element, IncrementalEvaluation<Permutation> incEval) {
        if (this.HAS_SETUPS) {
            double s;
            double denominator = 1.0 + (double)(p.size() == 0 ? this.data.getSetupTime(element) : this.data.getSetupTime(p.getLast(), element));
            int n = p.numExtensions();
            if (n > 1) {
                int minS = Integer.MAX_VALUE;
                for (int i = 0; i < n; ++i) {
                    int nextS;
                    int k = p.getExtension(i);
                    if (k == element || (nextS = this.data.getSetupTime(element, k)) >= minS) continue;
                    minS = nextS;
                }
                denominator += (double)minS;
            }
            return (s = 1.0 / denominator) <= 1.0E-5 ? 1.0E-5 : s;
        }
        return 1.0;
    }
}

