/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.problems.scheduling;

import org.cicirello.permutations.Permutation;
import org.cicirello.search.problems.scheduling.SchedulingHeuristic;
import org.cicirello.search.problems.scheduling.SingleMachineSchedulingProblem;
import org.cicirello.search.ss.IncrementalEvaluation;
import org.cicirello.search.ss.Partial;

public final class MinimumSlackTime
extends SchedulingHeuristic {
    private final int DMAX;
    private final double[] h;

    public MinimumSlackTime(SingleMachineSchedulingProblem problem) {
        super(problem);
        if (!this.data.hasDueDates()) {
            throw new IllegalArgumentException("This heuristic requires due dates.");
        }
        this.DMAX = this.computeDMax();
        this.h = new double[this.data.numberOfJobs()];
        for (int i = 0; i < this.h.length; ++i) {
            this.h[i] = this.DMAX + this.data.getProcessingTime(i) - this.data.getDueDate(i);
        }
    }

    @Override
    public double h(Partial<Permutation> p, int element, IncrementalEvaluation<Permutation> incEval) {
        if (this.HAS_SETUPS) {
            return this.h[element] + (double)(p.size() == 0 ? this.data.getSetupTime(element) : this.data.getSetupTime(p.getLast(), element));
        }
        return this.h[element];
    }

    private int computeDMax() {
        int max = this.data.getDueDate(0);
        int n = this.data.numberOfJobs();
        for (int i = 1; i < n; ++i) {
            if (this.data.getDueDate(i) <= max) continue;
            max = this.data.getDueDate(i);
        }
        return max;
    }
}

