/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.problems.scheduling;

import org.cicirello.permutations.Permutation;
import org.cicirello.search.problems.scheduling.SingleMachineSchedulingProblem;
import org.cicirello.search.problems.scheduling.SingleMachineSchedulingProblemData;

public final class MinimizeMaximumLateness
implements SingleMachineSchedulingProblem {
    private final SingleMachineSchedulingProblemData instanceData;

    public MinimizeMaximumLateness(SingleMachineSchedulingProblemData instanceData) {
        this.instanceData = instanceData;
        if (!instanceData.hasDueDates()) {
            throw new IllegalArgumentException("This cost function requires due dates.");
        }
    }

    @Override
    public SingleMachineSchedulingProblemData getInstanceData() {
        return this.instanceData;
    }

    @Override
    public int cost(Permutation candidate) {
        int[] c = this.instanceData.getCompletionTimes(candidate);
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < c.length; ++i) {
            int lateness = c[i] - this.instanceData.getDueDate(i);
            if (lateness <= max) continue;
            max = lateness;
        }
        return max;
    }

    @Override
    public int value(Permutation candidate) {
        return this.cost(candidate);
    }
}

