/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.problems.binpack;

import java.util.SplittableRandom;
import java.util.random.RandomGenerator;
import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.permutations.Permutation;
import org.cicirello.search.problems.IntegerCostOptimizationProblem;
import org.cicirello.search.problems.binpack.BinPackingSolution;
import org.cicirello.util.IntegerList;

public class BinPacking
implements IntegerCostOptimizationProblem<Permutation> {
    private final int[] items;
    private final int capacity;
    private final int lowerBound;

    BinPacking(int capacity, int[] items) {
        this.capacity = capacity;
        this.items = items;
        int total = 0;
        for (int i = 0; i < items.length; ++i) {
            if (items[i] > capacity) {
                throw new IllegalArgumentException("at least one item is large than the bin capacity");
            }
            total += items[i];
        }
        this.lowerBound = total / capacity + (total % capacity > 0 ? 1 : 0);
    }

    public final int getCapacity() {
        return this.capacity;
    }

    public final int numItems() {
        return this.items.length;
    }

    public final int getSize(int i) {
        return this.items[i];
    }

    @Override
    public final int cost(Permutation candidate) {
        IntegerList bins = new IntegerList();
        for (int i = 0; i < candidate.length(); ++i) {
            int id = candidate.get(i);
            boolean added = false;
            for (int j = 0; j < bins.size(); ++j) {
                int space = bins.get(j);
                if (space < this.items[id]) continue;
                bins.set(j, space - this.items[id]);
                added = true;
                break;
            }
            if (added) continue;
            bins.add(this.capacity - this.items[id]);
        }
        return bins.size();
    }

    @Override
    public final int value(Permutation candidate) {
        return this.cost(candidate);
    }

    @Override
    public final int minCost() {
        return this.lowerBound;
    }

    public final BinPackingSolution permutationToBinPackingSolution(Permutation p) {
        return new BinPackingSolution(p, this.capacity, this.items);
    }

    public static final class Triplet
    extends BinPacking {
        private static final int MIN_INTERVAL_1 = 380;
        private static final int MIN_INTERVAL_2 = 250;
        private static final int BOUND_INTERVAL_1 = 111;
        private static final int CAPACITY = 1000;

        public Triplet(int numItemTriplets) {
            super(1000, Triplet.createItems(numItemTriplets, new SplittableRandom()));
        }

        public Triplet(int numItemTriplets, long seed) {
            super(1000, Triplet.createItems(numItemTriplets, new SplittableRandom(seed)));
        }

        private static int[] createItems(int numItemTriplets, RandomGenerator gen) {
            int[] items = new int[numItemTriplets * 3];
            int i = 0;
            for (int t = 0; t < numItemTriplets; ++t) {
                items[i] = 380 + RandomIndexer.nextInt((int)111, (RandomGenerator)gen);
                int space = 1000 - items[i];
                int bound = (space >> 1) - 250 + ((space & 1) != 0 ? 1 : 0);
                items[++i] = 250 + RandomIndexer.nextInt((int)bound, (RandomGenerator)gen);
                space -= items[i];
                items[++i] = space;
                ++i;
            }
            Triplet.shuffle(items, gen);
            return items;
        }

        private static void shuffle(int[] items, RandomGenerator gen) {
            for (int bound = items.length; bound > 1; --bound) {
                int i = bound - 1;
                int j = RandomIndexer.nextInt((int)bound, (RandomGenerator)gen);
                if (i == j) continue;
                int temp = items[i];
                items[i] = items[j];
                items[j] = temp;
            }
        }
    }

    public static final class UniformRandom
    extends BinPacking {
        public UniformRandom(int numItems) {
            this(numItems, 150, 20, 100);
        }

        public UniformRandom(int numItems, long seed) {
            this(numItems, 150, 20, 100, seed);
        }

        public UniformRandom(int numItems, int capacity, int minSize, int maxSize) {
            super(capacity, UniformRandom.createItems(numItems, minSize, maxSize, new SplittableRandom()));
        }

        public UniformRandom(int numItems, int capacity, int minSize, int maxSize, long seed) {
            super(capacity, UniformRandom.createItems(numItems, minSize, maxSize, new SplittableRandom(seed)));
        }

        private static int[] createItems(int numItems, int minSize, int maxSize, RandomGenerator gen) {
            if (minSize > maxSize) {
                throw new IllegalArgumentException("min and max sizes are inconsistent");
            }
            int[] items = new int[numItems];
            int bound = maxSize - minSize + 1;
            for (int i = 0; i < numItems; ++i) {
                items[i] = minSize + RandomIndexer.nextInt((int)bound, (RandomGenerator)gen);
            }
            return items;
        }
    }
}

