/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.problems;

import org.cicirello.search.problems.IntegerCostOptimizationProblem;
import org.cicirello.search.representations.BitVector;

public final class RoyalRoad
implements IntegerCostOptimizationProblem<BitVector> {
    private final int blockSize;
    private final boolean steppingStones;

    public RoyalRoad(int blockSize, boolean steppingStones) {
        if (blockSize < 1) {
            throw new IllegalArgumentException("blockSize must be positive");
        }
        this.blockSize = blockSize;
        this.steppingStones = steppingStones;
    }

    @Override
    public int cost(BitVector candidate) {
        int maxValue = this.steppingStones ? (2 + this.intermediateLevelCount(candidate.length())) * candidate.length() : candidate.length() << 1;
        return maxValue - this.value(candidate);
    }

    @Override
    public int minCost() {
        return 0;
    }

    @Override
    public boolean isMinCost(int cost) {
        return cost == 0;
    }

    @Override
    public int value(BitVector candidate) {
        int total = candidate.allOnes() ? candidate.length() : 0;
        total += this.blockSize > 32 ? this.calculateLevelLargeBlock(candidate, this.blockSize) : this.calculateLevel(candidate, this.blockSize);
        if (this.steppingStones) {
            for (int m = this.blockSize << 1; m < candidate.length(); m <<= 1) {
                total += m > 32 ? this.calculateLevelLargeBlock(candidate, m) : this.calculateLevel(candidate, m);
            }
        }
        return total;
    }

    private int calculateLevelLargeBlock(BitVector candidate, int m) {
        int total = 0;
        BitVector.BitIterator iter = candidate.bitIterator(32);
        while (iter.numRemainingBits() >= m) {
            if (!new BitVector(m, iter.nextLargeBitBlock(m)).allOnes()) continue;
            total += m;
        }
        m = iter.numRemainingBits();
        if (m > 0 && new BitVector(m, iter.nextLargeBitBlock(m)).allOnes()) {
            total += m;
        }
        return total;
    }

    private int calculateLevel(BitVector candidate, int m) {
        int mask;
        int total = 0;
        BitVector.BitIterator iter = candidate.bitIterator(m);
        int n = mask = m == 32 ? -1 : (1 << m) - 1;
        while (iter.numRemainingBits() >= m) {
            if (iter.nextBitBlock() != mask) continue;
            total += m;
        }
        m = iter.numRemainingBits();
        if (m > 0) {
            mask = (1 << m) - 1;
            if (iter.nextBitBlock() == mask) {
                total += m;
            }
        }
        return total;
    }

    private int intermediateLevelCount(int n) {
        int count = 0;
        for (int m = this.blockSize << 1; m < n; m <<= 1) {
            ++count;
        }
        return count;
    }
}

