/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.problems;

import org.cicirello.search.problems.OptimizationProblem;
import org.cicirello.search.representations.BitVector;

public final class Plateaus
implements OptimizationProblem<BitVector> {
    @Override
    public double cost(BitVector candidate) {
        return (double)(10 * candidate.length()) - this.value(candidate);
    }

    @Override
    public double minCost() {
        return 0.0;
    }

    @Override
    public double value(BitVector candidate) {
        int i;
        int m = candidate.length() >> 2;
        int r = candidate.length() & 3;
        int blockCount = 0;
        BitVector.BitIterator iter = candidate.bitIterator(32);
        for (i = r; i < 4; ++i) {
            if (!this.isBlockAllOnes(iter, m)) continue;
            ++blockCount;
        }
        if (r > 0) {
            ++m;
            for (i = 0; i < r; ++i) {
                if (!this.isBlockAllOnes(iter, m)) continue;
                ++blockCount;
            }
        }
        return (double)(blockCount * candidate.length()) * 2.5;
    }

    @Override
    public boolean isMinCost(double cost) {
        return cost == 0.0;
    }

    private boolean isBlockAllOnes(BitVector.BitIterator iter, int stillNeed) {
        while (stillNeed >= 32) {
            stillNeed -= 32;
            if (iter.nextBitBlock() == -1) continue;
            iter.skip(stillNeed);
            return false;
        }
        if (stillNeed > 0) {
            int mask = (1 << stillNeed) - 1;
            if (iter.nextBitBlock(stillNeed) != mask) {
                return false;
            }
        }
        return true;
    }
}

