/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.problems;

import org.cicirello.permutations.Permutation;
import org.cicirello.search.operators.Initializer;
import org.cicirello.search.operators.bits.BitVectorInitializer;
import org.cicirello.search.problems.IntegerCostOptimizationProblem;
import org.cicirello.search.problems.OptimizationProblem;
import org.cicirello.search.representations.BitVector;

public class PermutationToBitVectorProblem
implements Initializer<BitVector> {
    private final BitVectorInitializer init;
    private final int bitsPerElement;
    private final int permutationLength;

    public PermutationToBitVectorProblem(int permutationLength) {
        if (permutationLength < 1) {
            throw new IllegalArgumentException("permutationLength must be positive");
        }
        this.bitsPerElement = 32 - Integer.numberOfLeadingZeros(permutationLength - 1);
        this.init = new BitVectorInitializer(this.bitsPerElement * (permutationLength - 1));
        this.permutationLength = permutationLength;
    }

    PermutationToBitVectorProblem(PermutationToBitVectorProblem other) {
        this.init = other.init.split();
        this.bitsPerElement = other.bitsPerElement;
        this.permutationLength = other.permutationLength;
    }

    @Override
    public final BitVector createCandidateSolution() {
        return this.init.createCandidateSolution();
    }

    @Override
    public PermutationToBitVectorProblem split() {
        return new PermutationToBitVectorProblem(this);
    }

    public final Permutation toPermutation(BitVector bits) {
        Permutation p = new Permutation(this.permutationLength, 0);
        if (this.permutationLength > 1) {
            BitVector.BitIterator iter = bits.bitIterator(this.bitsPerElement);
            for (int remaining = this.permutationLength; remaining > 1; --remaining) {
                int j = this.permutationLength - remaining;
                int i = j + iter.nextBitBlock() % remaining;
                if (i == j) continue;
                p.removeAndInsert(i, j);
            }
        }
        return p;
    }

    public final int supportedBitVectorLength() {
        return this.bitsPerElement * (this.permutationLength - 1);
    }

    public static final class IntegerCost
    extends PermutationToBitVectorProblem
    implements IntegerCostOptimizationProblem<BitVector> {
        private final IntegerCostOptimizationProblem<Permutation> problem;

        public IntegerCost(IntegerCostOptimizationProblem<Permutation> problem, int permutationLength) {
            super(permutationLength);
            this.problem = problem;
        }

        IntegerCost(IntegerCost other) {
            super(other);
            this.problem = other.problem;
        }

        @Override
        public IntegerCost split() {
            return new IntegerCost(this);
        }

        @Override
        public int cost(BitVector candidate) {
            return this.problem.cost(this.toPermutation(candidate));
        }

        @Override
        public double costAsDouble(BitVector candidate) {
            return this.problem.costAsDouble(this.toPermutation(candidate));
        }

        @Override
        public boolean isMinCost(int cost) {
            return this.problem.isMinCost(cost);
        }

        @Override
        public int minCost() {
            return this.problem.minCost();
        }

        @Override
        public int value(BitVector candidate) {
            return this.problem.value(this.toPermutation(candidate));
        }
    }

    public static final class DoubleCost
    extends PermutationToBitVectorProblem
    implements OptimizationProblem<BitVector> {
        private final OptimizationProblem<Permutation> problem;

        public DoubleCost(OptimizationProblem<Permutation> problem, int permutationLength) {
            super(permutationLength);
            this.problem = problem;
        }

        DoubleCost(DoubleCost other) {
            super(other);
            this.problem = other.problem;
        }

        @Override
        public DoubleCost split() {
            return new DoubleCost(this);
        }

        @Override
        public double cost(BitVector candidate) {
            return this.problem.cost(this.toPermutation(candidate));
        }

        @Override
        public double costAsDouble(BitVector candidate) {
            return this.problem.costAsDouble(this.toPermutation(candidate));
        }

        @Override
        public boolean isMinCost(double cost) {
            return this.problem.isMinCost(cost);
        }

        @Override
        public double minCost() {
            return this.problem.minCost();
        }

        @Override
        public double value(BitVector candidate) {
            return this.problem.value(this.toPermutation(candidate));
        }
    }
}

