/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.problems;

import org.cicirello.search.problems.OptimizationProblem;
import org.cicirello.search.representations.BitVector;

public final class HollandRoyalRoad
implements OptimizationProblem<BitVector> {
    private final int blockSize;
    private final int gapSize;
    private final int k;
    private final int numBlocks;
    private final int n;
    private final int mStar;
    private final double v;
    private final double uStar;
    private final double u;
    private final double maxFitness;

    public HollandRoyalRoad() {
        this(4, 8, 7, 4, 0.02, 1.0, 0.3);
    }

    public HollandRoyalRoad(int k, int blockSize, int gapSize, int mStar, double v, double uStar, double u) {
        if (k < 0) {
            throw new IllegalArgumentException("k must be non-negative");
        }
        if (blockSize < 1) {
            throw new IllegalArgumentException("blockSize must be positive");
        }
        if (gapSize < 0) {
            throw new IllegalArgumentException("gapSize must be non-negative");
        }
        if (mStar < 0 || mStar > blockSize) {
            throw new IllegalArgumentException("mStar must be non-negative and not greater than blockSize");
        }
        if (v < 0.0) {
            throw new IllegalArgumentException("v must be non-negative");
        }
        if (uStar < 0.0) {
            throw new IllegalArgumentException("uStar must be non-negative");
        }
        if (u < 0.0) {
            throw new IllegalArgumentException("u must be non-negative");
        }
        this.blockSize = blockSize;
        this.gapSize = gapSize;
        this.k = k;
        this.numBlocks = 1 << k;
        this.n = this.numBlocks * (blockSize + gapSize);
        this.mStar = mStar;
        this.v = v;
        this.uStar = uStar;
        this.u = u;
        this.maxFitness = Math.max(this.maxBonusFitness(), this.maxPartFitness());
    }

    public int supportedBitVectorLength() {
        return this.n;
    }

    @Override
    public double cost(BitVector candidate) {
        return this.maxFitness - this.value(candidate);
    }

    @Override
    public double minCost() {
        return 0.0;
    }

    @Override
    public boolean isMinCost(double cost) {
        return cost <= 0.0;
    }

    @Override
    public double value(BitVector candidate) {
        if (candidate.length() != this.n) {
            throw new IllegalArgumentException("The candidate BitVector's length is inconsistent with this HollandRoyalRoad's configuration.");
        }
        double fitness = 0.0;
        BitVector.BitIterator iter = candidate.bitIterator(this.blockSize);
        boolean[] completedBlocks = new boolean[this.numBlocks];
        for (int i = 0; i < this.numBlocks; ++i) {
            int partBitCount = new BitVector(this.blockSize, iter.nextLargeBitBlock(this.blockSize)).countOnes();
            if (partBitCount < this.blockSize) {
                fitness = partBitCount <= this.mStar ? (fitness += this.v * (double)partBitCount) : (fitness -= (double)(partBitCount - this.mStar) * this.v);
            } else {
                completedBlocks[i] = true;
            }
            iter.skip(this.gapSize);
        }
        return fitness += this.bonus(completedBlocks);
    }

    private double bonus(boolean[] completedBlocks) {
        double bonusFitness = 0.0;
        int size = completedBlocks.length;
        for (int level = 0; level <= this.k; ++level) {
            int count = 0;
            for (int i = 0; i < size; ++i) {
                if (!completedBlocks[i]) continue;
                ++count;
            }
            if (count <= 0) break;
            bonusFitness += this.uStar + (double)(count - 1) * this.u;
            size >>= 1;
            for (int j = 0; j < size; ++j) {
                int x = j << 1;
                completedBlocks[j] = completedBlocks[x] && completedBlocks[x + 1];
            }
        }
        return bonusFitness;
    }

    private double maxBonusFitness() {
        return (double)(this.k + 1) * this.uStar + this.u * (double)((1 << this.k + 1) - this.k - 2);
    }

    private double maxPartFitness() {
        if (this.mStar >= this.blockSize) {
            return (double)(this.mStar - 1) * this.v * (double)this.numBlocks;
        }
        return (double)this.mStar * this.v * (double)this.numBlocks;
    }
}

