/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators.reals;

import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.search.operators.UndoableMutationOperator;
import org.cicirello.search.operators.reals.CauchyMutation;
import org.cicirello.search.representations.RealValued;

public class UndoableCauchyMutation<T extends RealValued>
extends CauchyMutation<T>
implements UndoableMutationOperator<T> {
    double[] previous;
    double old;

    UndoableCauchyMutation(double scale) {
        super(scale);
    }

    UndoableCauchyMutation(UndoableCauchyMutation<T> other) {
        super(other);
    }

    public static <T extends RealValued> UndoableCauchyMutation<T> createCauchyMutation() {
        return new UndoableCauchyMutation<T>(1.0);
    }

    public static <T extends RealValued> UndoableCauchyMutation<T> createCauchyMutation(double scale) {
        return new UndoableCauchyMutation<T>(scale);
    }

    public static <T extends RealValued> UndoableCauchyMutation<T> createCauchyMutation(double scale, int k) {
        if (k < 1) {
            throw new IllegalArgumentException("k must be at least 1");
        }
        return new UndoablePartialCauchyMutation(scale, k);
    }

    public static <T extends RealValued> UndoableCauchyMutation<T> createCauchyMutation(double scale, double p) {
        if (p <= 0.0) {
            throw new IllegalArgumentException("p must be positive");
        }
        return p >= 1.0 ? new UndoableCauchyMutation<T>(scale) : new UndoablePartialCauchyMutation(scale, p);
    }

    @Override
    public void mutate(T c) {
        if (c.length() > 1) {
            this.previous = c.toArray(this.previous);
            this.internalMutate(c, this.previous);
        } else if (c.length() == 1) {
            this.old = c.get(0);
            this.internalMutate(c, this.old);
        }
    }

    @Override
    public void undo(T c) {
        if (c.length() > 1) {
            for (int i = 0; i < c.length(); ++i) {
                c.set(i, this.previous[i]);
            }
        } else if (c.length() == 1) {
            c.set(0, this.old);
        }
    }

    @Override
    public UndoableCauchyMutation<T> split() {
        return new UndoableCauchyMutation<T>(this);
    }

    @Override
    public UndoableCauchyMutation<T> copy() {
        return new UndoableCauchyMutation<T>(this);
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && other instanceof UndoableCauchyMutation;
    }

    private static final class UndoablePartialCauchyMutation<T extends RealValued>
    extends UndoableCauchyMutation<T> {
        private final int k;
        private final double p;
        private int[] indexes;

        UndoablePartialCauchyMutation(double scale, int k) {
            super(scale);
            this.k = k;
            this.p = -1.0;
        }

        UndoablePartialCauchyMutation(double scale, double p) {
            super(scale);
            this.p = p;
            this.k = 0;
        }

        UndoablePartialCauchyMutation(UndoablePartialCauchyMutation<T> other) {
            super(other);
            this.k = other.k;
            this.p = other.p;
        }

        @Override
        public void mutate(T c) {
            if (this.k >= c.length()) {
                super.mutate(c);
            } else {
                int[] nArray = this.indexes = this.p < 0.0 ? RandomIndexer.sample((int)c.length(), (int)this.k, (int[])this.indexes) : RandomIndexer.sample((int)c.length(), (double)this.p);
                if (this.previous == null || this.previous.length < this.indexes.length) {
                    this.previous = new double[this.indexes.length];
                }
                for (int i = 0; i < this.indexes.length; ++i) {
                    this.previous[i] = c.get(this.indexes[i]);
                }
                this.internalPartialMutation(c, this.indexes, this.previous);
            }
        }

        @Override
        public void undo(T c) {
            if (this.k >= c.length()) {
                super.undo(c);
            } else {
                for (int i = 0; i < this.indexes.length; ++i) {
                    c.set(this.indexes[i], this.previous[i]);
                }
            }
        }

        @Override
        public boolean equals(Object other) {
            if (other == null || !(other instanceof UndoablePartialCauchyMutation) || !super.equals(other)) {
                return false;
            }
            UndoablePartialCauchyMutation g = (UndoablePartialCauchyMutation)other;
            return this.k == g.k && this.p == g.p;
        }

        @Override
        public int hashCode() {
            return 31 * super.hashCode() + (this.p < 0.0 ? this.k : Double.hashCode(this.p));
        }

        @Override
        public UndoablePartialCauchyMutation<T> split() {
            return new UndoablePartialCauchyMutation<T>(this);
        }

        @Override
        public UndoablePartialCauchyMutation<T> copy() {
            return new UndoablePartialCauchyMutation<T>(this);
        }
    }
}

