/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators.reals;

import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.math.rand.RandomVariates;
import org.cicirello.search.operators.MutationOperator;
import org.cicirello.search.representations.RealValued;
import org.cicirello.util.Copyable;

public class GaussianMutation<T extends RealValued>
implements MutationOperator<T>,
RealValued,
Copyable<GaussianMutation<T>> {
    private double sigma;

    GaussianMutation(double sigma) {
        this.sigma = sigma;
    }

    GaussianMutation(GaussianMutation<T> other) {
        this.sigma = other.sigma;
    }

    public static <T extends RealValued> GaussianMutation<T> createGaussianMutation() {
        return new GaussianMutation<T>(1.0);
    }

    public static <T extends RealValued> GaussianMutation<T> createGaussianMutation(double sigma) {
        return new GaussianMutation<T>(sigma);
    }

    public static <T extends RealValued> GaussianMutation<T> createGaussianMutation(double sigma, int k) {
        if (k < 1) {
            throw new IllegalArgumentException("k must be at least 1");
        }
        return new PartialGaussianMutation(sigma, k);
    }

    public static <T extends RealValued> GaussianMutation<T> createGaussianMutation(double sigma, double p) {
        if (p <= 0.0) {
            throw new IllegalArgumentException("p must be positive");
        }
        return p >= 1.0 ? new GaussianMutation<T>(sigma) : new PartialGaussianMutation(sigma, p);
    }

    @Override
    public void mutate(T c) {
        int n = c.length();
        for (int i = 0; i < n; ++i) {
            c.set(i, c.get(i) + RandomVariates.nextGaussian((double)this.sigma));
        }
    }

    @Override
    public GaussianMutation<T> split() {
        return new GaussianMutation<T>(this);
    }

    public GaussianMutation<T> copy() {
        return new GaussianMutation<T>(this);
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof GaussianMutation)) {
            return false;
        }
        GaussianMutation g = (GaussianMutation)other;
        return this.sigma == g.sigma;
    }

    public int hashCode() {
        return Double.hashCode(this.sigma);
    }

    @Override
    public final int length() {
        return 1;
    }

    @Override
    public final double get(int i) {
        return this.sigma;
    }

    @Override
    public final double[] toArray(double[] values) {
        if (values == null || values.length != 1) {
            values = new double[]{this.sigma};
        }
        return values;
    }

    @Override
    public final void set(int i, double value) {
        this.sigma = value;
    }

    final void internalMutate(T c, double[] old) {
        for (int i = 0; i < old.length; ++i) {
            c.set(i, old[i] + RandomVariates.nextGaussian((double)this.sigma));
        }
    }

    final void internalMutate(T c, double old) {
        c.set(0, old + RandomVariates.nextGaussian((double)this.sigma));
    }

    final void internalPartialMutation(T c, int[] indexes) {
        for (int j = 0; j < indexes.length; ++j) {
            int i = indexes[j];
            c.set(i, c.get(i) + RandomVariates.nextGaussian((double)this.sigma));
        }
    }

    final void internalPartialMutation(T c, int[] indexes, double[] old) {
        for (int j = 0; j < indexes.length; ++j) {
            c.set(indexes[j], old[j] + RandomVariates.nextGaussian((double)this.sigma));
        }
    }

    private static final class PartialGaussianMutation<T extends RealValued>
    extends GaussianMutation<T> {
        private final int k;
        private final double p;

        PartialGaussianMutation(double sigma, int k) {
            super(sigma);
            this.k = k;
            this.p = -1.0;
        }

        PartialGaussianMutation(double sigma, double p) {
            super(sigma);
            this.p = p;
            this.k = 0;
        }

        PartialGaussianMutation(PartialGaussianMutation<T> other) {
            super(other);
            this.k = other.k;
            this.p = other.p;
        }

        @Override
        public void mutate(T c) {
            if (this.k >= c.length()) {
                super.mutate(c);
            } else {
                int[] indexes = this.p < 0.0 ? RandomIndexer.sample((int)c.length(), (int)this.k, (int[])null) : RandomIndexer.sample((int)c.length(), (double)this.p);
                this.internalPartialMutation(c, indexes);
            }
        }

        @Override
        public boolean equals(Object other) {
            if (!super.equals(other) || !(other instanceof PartialGaussianMutation)) {
                return false;
            }
            PartialGaussianMutation g = (PartialGaussianMutation)other;
            return this.k == g.k && this.p == g.p;
        }

        @Override
        public int hashCode() {
            return 31 * super.hashCode() + (this.p < 0.0 ? this.k : Double.hashCode(this.p));
        }

        @Override
        public PartialGaussianMutation<T> split() {
            return new PartialGaussianMutation<T>(this);
        }

        @Override
        public PartialGaussianMutation<T> copy() {
            return new PartialGaussianMutation<T>(this);
        }
    }
}

