/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators.reals;

import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.math.rand.RandomVariates;
import org.cicirello.search.operators.MutationOperator;
import org.cicirello.search.representations.RealValued;
import org.cicirello.util.Copyable;

public class CauchyMutation<T extends RealValued>
implements MutationOperator<T>,
RealValued,
Copyable<CauchyMutation<T>> {
    private double scale;

    CauchyMutation(double scale) {
        this.scale = scale;
    }

    CauchyMutation(CauchyMutation<T> other) {
        this.scale = other.scale;
    }

    public static <T extends RealValued> CauchyMutation<T> createCauchyMutation() {
        return new CauchyMutation<T>(1.0);
    }

    public static <T extends RealValued> CauchyMutation<T> createCauchyMutation(double scale) {
        return new CauchyMutation<T>(scale);
    }

    public static <T extends RealValued> CauchyMutation<T> createCauchyMutation(double scale, int k) {
        if (k < 1) {
            throw new IllegalArgumentException("k must be at least 1");
        }
        return new PartialCauchyMutation(scale, k);
    }

    public static <T extends RealValued> CauchyMutation<T> createCauchyMutation(double scale, double p) {
        if (p <= 0.0) {
            throw new IllegalArgumentException("p must be positive");
        }
        return p >= 1.0 ? new CauchyMutation<T>(scale) : new PartialCauchyMutation(scale, p);
    }

    @Override
    public void mutate(T c) {
        int n = c.length();
        for (int i = 0; i < n; ++i) {
            c.set(i, c.get(i) + RandomVariates.nextCauchy((double)this.scale));
        }
    }

    @Override
    public CauchyMutation<T> split() {
        return new CauchyMutation<T>(this);
    }

    public CauchyMutation<T> copy() {
        return new CauchyMutation<T>(this);
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof CauchyMutation)) {
            return false;
        }
        CauchyMutation g = (CauchyMutation)other;
        return this.scale == g.scale;
    }

    public int hashCode() {
        return Double.hashCode(this.scale);
    }

    @Override
    public final int length() {
        return 1;
    }

    @Override
    public final double get(int i) {
        return this.scale;
    }

    @Override
    public final double[] toArray(double[] values) {
        if (values == null || values.length != 1) {
            values = new double[]{this.scale};
        }
        return values;
    }

    @Override
    public final void set(int i, double value) {
        this.scale = value;
    }

    final void internalMutate(T c, double[] old) {
        for (int i = 0; i < old.length; ++i) {
            c.set(i, old[i] + RandomVariates.nextCauchy((double)this.scale));
        }
    }

    final void internalMutate(T c, double old) {
        c.set(0, old + RandomVariates.nextCauchy((double)this.scale));
    }

    final void internalPartialMutation(T c, int[] indexes) {
        for (int j = 0; j < indexes.length; ++j) {
            int i = indexes[j];
            c.set(i, c.get(i) + RandomVariates.nextCauchy((double)this.scale));
        }
    }

    final void internalPartialMutation(T c, int[] indexes, double[] old) {
        for (int j = 0; j < indexes.length; ++j) {
            c.set(indexes[j], old[j] + RandomVariates.nextCauchy((double)this.scale));
        }
    }

    private static final class PartialCauchyMutation<T extends RealValued>
    extends CauchyMutation<T> {
        private final int k;
        private final double p;

        PartialCauchyMutation(double scale, int k) {
            super(scale);
            this.k = k;
            this.p = -1.0;
        }

        PartialCauchyMutation(double scale, double p) {
            super(scale);
            this.p = p;
            this.k = 0;
        }

        PartialCauchyMutation(PartialCauchyMutation<T> other) {
            super(other);
            this.k = other.k;
            this.p = other.p;
        }

        @Override
        public void mutate(T c) {
            if (this.k >= c.length()) {
                super.mutate(c);
            } else {
                int[] indexes = this.p < 0.0 ? RandomIndexer.sample((int)c.length(), (int)this.k, (int[])null) : RandomIndexer.sample((int)c.length(), (double)this.p);
                this.internalPartialMutation(c, indexes);
            }
        }

        @Override
        public boolean equals(Object other) {
            if (other == null || !(other instanceof PartialCauchyMutation) || !super.equals(other)) {
                return false;
            }
            PartialCauchyMutation g = (PartialCauchyMutation)other;
            return this.k == g.k && this.p == g.p;
        }

        @Override
        public int hashCode() {
            return 31 * super.hashCode() + (this.p < 0.0 ? this.k : Double.hashCode(this.p));
        }

        @Override
        public PartialCauchyMutation<T> split() {
            return new PartialCauchyMutation<T>(this);
        }

        @Override
        public PartialCauchyMutation<T> copy() {
            return new PartialCauchyMutation<T>(this);
        }
    }
}

