/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators.permutations;

import org.cicirello.permutations.Permutation;
import org.cicirello.search.operators.MutationIterator;

final class WindowLimitedSwapIterator
implements MutationIterator {
    private boolean rolled;
    private boolean hasMore;
    private final Permutation p;
    private final int w;
    private int i;
    private int j;
    private int x;
    private int y;

    WindowLimitedSwapIterator(Permutation p, int w) {
        this.p = p;
        this.w = w;
        this.hasMore = p.length() >= 2;
    }

    @Override
    public boolean hasNext() {
        return this.hasMore && !this.rolled;
    }

    @Override
    public void nextMutant() {
        if (!this.hasMore) {
            throw new IllegalStateException("no neighbors left");
        }
        if (this.rolled) {
            throw new IllegalStateException("illegal to call nextMutant after calling rollback");
        }
        if (this.i != this.j) {
            this.p.swap(this.i, this.j);
        }
        ++this.j;
        if (this.j >= this.p.length() || this.j - this.i > this.w) {
            ++this.i;
            this.j = this.i + 1;
        }
        this.p.swap(this.i, this.j);
        if (this.i == this.p.length() - 2) {
            this.hasMore = false;
        }
    }

    @Override
    public void setSavepoint() {
        this.x = this.i;
        this.y = this.j;
    }

    @Override
    public void rollback() {
        if (!this.rolled) {
            this.rolled = true;
            if (this.y == 0) {
                if (this.j > 0) {
                    this.p.swap(this.i, this.j);
                }
            } else if (this.i != this.x || this.j != this.y) {
                this.p.swap(this.i, this.j);
                this.p.swap(this.x, this.y);
            }
        }
    }
}

