/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators.permutations;

import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.permutations.Permutation;
import org.cicirello.search.operators.MutationIterator;
import org.cicirello.search.operators.permutations.InsertionMutation;
import org.cicirello.search.operators.permutations.WindowLimitedInsertionIterator;

public final class WindowLimitedInsertionMutation
extends InsertionMutation {
    private final int limit;

    public WindowLimitedInsertionMutation() {
        this(Integer.MAX_VALUE);
    }

    public WindowLimitedInsertionMutation(int windowLimit) {
        if (windowLimit <= 0) {
            throw new IllegalArgumentException("window limit must be positive");
        }
        this.limit = windowLimit;
    }

    @Override
    public WindowLimitedInsertionMutation split() {
        return new WindowLimitedInsertionMutation(this.limit);
    }

    @Override
    public MutationIterator iterator(Permutation p) {
        return new WindowLimitedInsertionIterator(p, this.limit);
    }

    @Override
    final void generateIndexes(int n, int[] indexes) {
        if (this.limit >= n) {
            super.generateIndexes(n, indexes);
        } else {
            RandomIndexer.nextWindowedIntPair((int)n, (int)this.limit, (int[])indexes);
        }
    }
}

