/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators.permutations;

import org.cicirello.permutations.Permutation;
import org.cicirello.search.operators.MutationIterator;

final class WindowLimitedBlockMoveIterator
implements MutationIterator {
    private boolean rolled;
    private boolean hasMore;
    private final Permutation p;
    private final int w;
    private int i;
    private int j;
    private int s;
    private int x;
    private int y;
    private int z;
    private final int MAX_S;
    private int nextS;

    WindowLimitedBlockMoveIterator(Permutation p, int w) {
        this.p = p;
        this.w = w;
        this.hasMore = p.length() >= 2;
        this.s = 1;
        this.nextS = 1;
        this.MAX_S = w < p.length() ? w + 1 >> 1 : p.length() >> 1;
    }

    @Override
    public boolean hasNext() {
        return this.hasMore && !this.rolled;
    }

    @Override
    public void nextMutant() {
        if (!this.hasMore) {
            throw new IllegalStateException("no neighbors left");
        }
        if (this.rolled) {
            throw new IllegalStateException("illegal to call nextMutant after calling rollback");
        }
        if (this.nextS == 1) {
            this.nextInsertion();
        } else {
            this.nextBlockInsertion();
        }
    }

    @Override
    public void setSavepoint() {
        this.x = this.i;
        this.y = this.j;
        this.z = this.s;
    }

    @Override
    public void rollback() {
        if (!this.rolled) {
            this.rolled = true;
            if (this.z > 0) {
                if (this.i != this.x || this.j != this.y || this.s != this.z) {
                    this.p.removeAndInsert(this.i, this.s, this.j);
                    this.p.removeAndInsert(this.y, this.z, this.x);
                }
            } else {
                this.p.removeAndInsert(this.i, this.s, this.j);
            }
        }
    }

    private void nextInsertion() {
        if (this.j >= this.i) {
            ++this.j;
            if (this.j >= this.p.length() || this.j - this.i > this.w) {
                this.p.removeAndInsert(this.i, this.j - 1);
                ++this.i;
                if (this.i >= this.p.length() - 1) {
                    this.i = 2;
                    this.j = 0;
                    this.p.swap(1, 2);
                } else {
                    this.j = this.i + 1;
                }
            }
        } else {
            --this.j;
            if (this.j < 0 || this.i - this.j > this.w) {
                this.p.removeAndInsert(this.i, this.j + 1);
                ++this.i;
                this.j = this.i - 2;
                this.p.swap(this.i, this.i - 1);
            }
        }
        this.p.swap(this.i, this.j);
        if (this.p.length() <= 2 || this.i == this.p.length() - 1 && (this.j == 0 || this.i - this.j == this.w) || this.w == 1 && this.i == this.p.length() - 2) {
            if (this.MAX_S == 1) {
                this.hasMore = false;
            } else {
                this.nextS = 2;
            }
        }
    }

    private void nextBlockInsertion() {
        if (this.s != this.nextS) {
            this.p.removeAndInsert(this.i, this.s, this.j);
            this.j = this.p.length() - this.nextS;
            this.i = this.j - this.nextS;
            this.s = this.nextS;
            this.p.removeAndInsert(this.j, this.s, this.i);
            if (this.i == 0) {
                this.hasMore = false;
            }
        } else if (this.j > this.i) {
            if (this.i > 0 && this.j + this.s - this.i <= this.w) {
                --this.i;
                this.p.removeAndInsert(this.i, this.i + this.s);
            } else if (this.j > this.s) {
                this.p.removeAndInsert(this.i, this.s, this.j);
                --this.j;
                this.i = this.j - this.s;
                this.p.removeAndInsert(this.j, this.s, this.i);
                if (this.i == 0 && this.s + this.s > this.w) {
                    this.hasMore = false;
                }
            } else {
                this.p.removeAndInsert(this.i, this.s, this.j);
                this.j = 0;
                this.i = this.s + 1;
                this.p.removeAndInsert(this.j, this.s, this.i);
                if (this.p.length() == this.s + this.s + 1) {
                    this.hasMore = false;
                }
            }
        } else if (this.i < this.p.length() - this.s && this.i + this.s - this.j <= this.w) {
            this.p.removeAndInsert(this.i + this.s, this.i);
            ++this.i;
        } else {
            this.p.removeAndInsert(this.i, this.s, this.j);
            ++this.j;
            this.i = this.j + this.s + 1;
            this.p.removeAndInsert(this.j, this.s, this.i);
            if (this.i == this.p.length() - this.s) {
                if (this.s == this.MAX_S) {
                    this.hasMore = false;
                } else {
                    ++this.nextS;
                }
            }
        }
    }
}

