/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators.permutations;

import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.permutations.Permutation;
import org.cicirello.search.operators.CrossoverOperator;

public final class UniformPrecedencePreservativeCrossover
implements CrossoverOperator<Permutation> {
    private final double u;

    public UniformPrecedencePreservativeCrossover() {
        this(0.5);
    }

    public UniformPrecedencePreservativeCrossover(double u) {
        if (u <= 0.0 || u >= 1.0) {
            throw new IllegalArgumentException("u must be: 0.0 < u < 1.0");
        }
        this.u = u;
    }

    @Override
    public void cross(Permutation c1, Permutation c2) {
        c1.apply((raw1, raw2) -> this.internalCross(raw1, raw2, RandomIndexer.arrayMask((int)raw1.length, (double)this.u)), c2);
    }

    @Override
    public UniformPrecedencePreservativeCrossover split() {
        return this;
    }

    final void internalCross(int[] raw1, int[] raw2, boolean[] mask) {
        int[] old1 = (int[])raw1.clone();
        int[] old2 = (int[])raw2.clone();
        boolean[] used1 = new boolean[raw1.length];
        boolean[] used2 = new boolean[raw1.length];
        int i = 0;
        int j = 0;
        int x = 0;
        int y = 0;
        for (int k = 0; k < mask.length; ++k) {
            if (mask[k]) {
                while (used1[old1[i]]) {
                    ++i;
                }
                while (used2[old2[j]]) {
                    ++j;
                }
                raw1[k] = old1[i];
                used1[raw1[k]] = true;
                raw2[k] = old2[j];
                used2[raw2[k]] = true;
                ++i;
                ++j;
                continue;
            }
            while (used1[old2[x]]) {
                ++x;
            }
            while (used2[old1[y]]) {
                ++y;
            }
            raw1[k] = old2[x];
            used1[raw1[k]] = true;
            raw2[k] = old1[y];
            used2[raw2[k]] = true;
            ++x;
            ++y;
        }
    }
}

