/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators.permutations;

import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.permutations.Permutation;
import org.cicirello.search.operators.CrossoverOperator;

public final class UniformPartiallyMatchedCrossover
implements CrossoverOperator<Permutation> {
    private final double u;

    public UniformPartiallyMatchedCrossover() {
        this(0.3333333333333333);
    }

    public UniformPartiallyMatchedCrossover(double u) {
        if (u <= 0.0 || u >= 1.0) {
            throw new IllegalArgumentException("u must be: 0.0 < u < 1.0");
        }
        this.u = u;
    }

    @Override
    public void cross(Permutation c1, Permutation c2) {
        this.internalCross(c1, c2, RandomIndexer.sample((int)c1.length(), (double)this.u));
    }

    @Override
    public UniformPartiallyMatchedCrossover split() {
        return this;
    }

    final void internalCross(Permutation c1, Permutation c2, int[] indexes) {
        int[] inv1 = c1.getInverse();
        int[] inv2 = c2.getInverse();
        int[] old1 = c1.toArray();
        int[] old2 = c2.toArray();
        for (int k : indexes) {
            int g = inv1[old2[k]];
            if (k != g) {
                c1.swap(k, g);
                inv1[c1.get((int)g)] = g;
                inv1[old2[k]] = k;
            }
            if (k == (g = inv2[old1[k]])) continue;
            c2.swap(k, g);
            inv2[c2.get((int)g)] = g;
            inv2[old1[k]] = k;
        }
    }
}

