/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators.permutations;

import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.permutations.Permutation;
import org.cicirello.search.operators.CrossoverOperator;
import org.cicirello.util.IntegerList;

public final class UniformOrderBasedCrossover
implements CrossoverOperator<Permutation> {
    private final double u;

    public UniformOrderBasedCrossover() {
        this(0.5);
    }

    public UniformOrderBasedCrossover(double u) {
        if (u <= 0.0 || u >= 1.0) {
            throw new IllegalArgumentException("u must be: 0.0 < u < 1.0");
        }
        this.u = u;
    }

    @Override
    public void cross(Permutation c1, Permutation c2) {
        c1.apply((raw1, raw2) -> {
            int[] indexes = RandomIndexer.sample((int)raw1.length, (double)this.u);
            boolean[] mask = new boolean[raw1.length];
            boolean[] in1 = new boolean[raw1.length];
            boolean[] in2 = new boolean[raw1.length];
            for (int k : indexes) {
                mask[k] = true;
                in1[raw1[k]] = true;
                in2[raw2[k]] = true;
            }
            int orderedCount = raw1.length - indexes.length;
            if (orderedCount > 0) {
                IntegerList list1 = new IntegerList(orderedCount);
                IntegerList list2 = new IntegerList(orderedCount);
                for (int k = 0; k < raw1.length; ++k) {
                    if (!in2[raw1[k]]) {
                        list1.add(raw1[k]);
                    }
                    if (in1[raw2[k]]) continue;
                    list2.add(raw2[k]);
                }
                int w = 0;
                for (int k = 0; k < mask.length; ++k) {
                    if (mask[k]) continue;
                    raw1[k] = list2.get(w);
                    raw2[k] = list1.get(w);
                    ++w;
                }
            }
        }, c2);
    }

    @Override
    public UniformOrderBasedCrossover split() {
        return this;
    }
}

