/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators.permutations;

import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.permutations.Permutation;
import org.cicirello.search.operators.UndoableMutationOperator;

public final class UndoableUniformScrambleMutation
implements UndoableMutationOperator<Permutation> {
    private final double u;
    private final boolean guaranteeChange;
    private int[] last;
    private int[] indexes;

    public UndoableUniformScrambleMutation(double u) {
        this(u, false);
    }

    public UndoableUniformScrambleMutation(double u, boolean guaranteeChange) {
        if (u < 0.0 || u > 1.0) {
            throw new IllegalArgumentException("u must be in [0.0, 1.0].");
        }
        this.u = u;
        this.guaranteeChange = guaranteeChange;
    }

    @Override
    public final void mutate(Permutation c) {
        if (c.length() >= 2) {
            this.last = c.toArray();
            this.indexes = RandomIndexer.sample((int)c.length(), (double)this.u);
            if (this.guaranteeChange && this.indexes.length < 2) {
                this.indexes = RandomIndexer.nextIntPair((int)c.length(), null);
            }
            c.scramble(this.indexes);
        }
    }

    @Override
    public final void undo(Permutation c) {
        if (c.length() >= 2) {
            c.apply(perm -> {
                for (int i = 0; i < this.indexes.length; ++i) {
                    perm[this.indexes[i]] = this.last[this.indexes[i]];
                }
            });
        }
    }

    @Override
    public UndoableUniformScrambleMutation split() {
        return new UndoableUniformScrambleMutation(this.u, this.guaranteeChange);
    }
}

