/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators.permutations;

import org.cicirello.permutations.Permutation;
import org.cicirello.search.operators.MutationIterator;

final class RotationIterator
implements MutationIterator {
    private boolean rolled;
    private boolean hasMore;
    private final Permutation p;
    private int r;
    private int x;

    RotationIterator(Permutation p) {
        this.p = p;
        this.hasMore = p.length() > 1;
    }

    @Override
    public boolean hasNext() {
        return this.hasMore && !this.rolled;
    }

    @Override
    public void nextMutant() {
        if (!this.hasMore) {
            throw new IllegalStateException("no neighbors left");
        }
        if (this.rolled) {
            throw new IllegalStateException("illegal to call nextMutant after calling rollback");
        }
        this.p.rotate(1);
        ++this.r;
        if (this.r == this.p.length() - 1) {
            this.hasMore = false;
        }
    }

    @Override
    public void setSavepoint() {
        this.x = this.r;
    }

    @Override
    public void rollback() {
        if (!this.rolled) {
            this.rolled = true;
            if (this.x != this.r) {
                this.p.rotate(this.p.length() - (this.r - this.x));
            }
        }
    }
}

