/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators.permutations;

import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.permutations.Permutation;
import org.cicirello.search.operators.CrossoverOperator;
import org.cicirello.util.IntegerList;

public final class OrderCrossoverTwo
implements CrossoverOperator<Permutation> {
    private final double u;

    public OrderCrossoverTwo() {
        this(0.5);
    }

    public OrderCrossoverTwo(double u) {
        if (u <= 0.0 || u >= 1.0) {
            throw new IllegalArgumentException("u must be: 0.0 < u < 1.0");
        }
        this.u = u;
    }

    @Override
    public void cross(Permutation c1, Permutation c2) {
        c1.apply((raw1, raw2, p1, p2) -> this.internalCross(raw1, raw2, p1, p2, RandomIndexer.arrayMask((int)raw1.length, (double)this.u)), c2);
    }

    @Override
    public OrderCrossoverTwo split() {
        return this;
    }

    final void internalCross(int[] raw1, int[] raw2, Permutation p1, Permutation p2, boolean[] mask) {
        int[] inv1 = p1.getInverse();
        int[] inv2 = p2.getInverse();
        IntegerList elementOrder1 = new IntegerList(raw1.length);
        IntegerList elementOrder2 = new IntegerList(raw1.length);
        boolean[] indexes1 = new boolean[raw1.length];
        boolean[] indexes2 = new boolean[raw1.length];
        for (int i = 0; i < mask.length; ++i) {
            if (!mask[i]) continue;
            elementOrder1.add(raw2[i]);
            elementOrder2.add(raw1[i]);
            indexes1[inv1[raw2[i]]] = true;
            indexes2[inv2[raw1[i]]] = true;
        }
        int j = 0;
        int k = 0;
        for (int i = 0; i < indexes1.length; ++i) {
            if (indexes1[i]) {
                raw1[i] = elementOrder1.get(j);
                ++j;
            }
            if (!indexes2[i]) continue;
            raw2[i] = elementOrder2.get(k);
            ++k;
        }
    }
}

