/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators.permutations;

import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.permutations.Permutation;
import org.cicirello.search.operators.CrossoverOperator;
import org.cicirello.util.IntegerList;

public final class OrderCrossover
implements CrossoverOperator<Permutation> {
    @Override
    public void cross(Permutation c1, Permutation c2) {
        c1.apply((raw1, raw2) -> {
            int i = RandomIndexer.nextInt((int)raw1.length);
            int j = RandomIndexer.nextInt((int)raw1.length);
            if (j < i) {
                int temp = i;
                i = j;
                j = temp;
            }
            boolean[] in1 = new boolean[raw1.length];
            boolean[] in2 = new boolean[raw1.length];
            for (int k = i; k <= j; ++k) {
                in1[raw1[k]] = true;
                in2[raw2[k]] = true;
            }
            int orderedCount = raw1.length - (j - i + 1);
            if (orderedCount > 0) {
                int k;
                IntegerList list1 = new IntegerList(orderedCount);
                IntegerList list2 = new IntegerList(orderedCount);
                for (int k2 = 0; k2 < raw1.length; ++k2) {
                    if (!in2[raw1[k2]]) {
                        list1.add(raw1[k2]);
                    }
                    if (in1[raw2[k2]]) continue;
                    list2.add(raw2[k2]);
                }
                int w = 0;
                for (k = j + 1; k < raw1.length; ++k) {
                    raw1[k] = list2.get(w);
                    raw2[k] = list1.get(w);
                    ++w;
                }
                for (k = 0; k < i; ++k) {
                    raw1[k] = list2.get(w);
                    raw2[k] = list1.get(w);
                    ++w;
                }
            }
        }, c2);
    }

    @Override
    public OrderCrossover split() {
        return this;
    }
}

