/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators.permutations;

import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.permutations.Permutation;
import org.cicirello.search.operators.IterableMutationOperator;
import org.cicirello.search.operators.MutationIterator;
import org.cicirello.search.operators.UndoableMutationOperator;
import org.cicirello.search.operators.permutations.InsertionIterator;

public class InsertionMutation
implements UndoableMutationOperator<Permutation>,
IterableMutationOperator<Permutation> {
    private final int[] indexes = new int[2];

    @Override
    public final void mutate(Permutation c) {
        if (c.length() >= 2) {
            this.generateIndexes(c.length(), this.indexes);
            c.removeAndInsert(this.indexes[0], this.indexes[1]);
        }
    }

    @Override
    public final void undo(Permutation c) {
        if (c.length() >= 2) {
            c.removeAndInsert(this.indexes[1], this.indexes[0]);
        }
    }

    @Override
    public InsertionMutation split() {
        return new InsertionMutation();
    }

    @Override
    public MutationIterator iterator(Permutation p) {
        return new InsertionIterator(p);
    }

    void generateIndexes(int n, int[] indexes) {
        RandomIndexer.nextIntPair((int)n, (int[])indexes);
    }
}

