/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators.permutations;

import java.util.Arrays;
import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.permutations.Permutation;
import org.cicirello.search.operators.CrossoverOperator;

public final class EnhancedEdgeRecombination
implements CrossoverOperator<Permutation> {
    @Override
    public void cross(Permutation c1, Permutation c2) {
        if (c1.length() <= 1) {
            return;
        }
        c1.apply((raw1, raw2) -> {
            EnhancedEdgeMap map = new EnhancedEdgeMap(raw1, raw2);
            this.build(raw1, new EnhancedEdgeMap(map));
            this.build(raw2, map);
        }, c2);
    }

    @Override
    public EnhancedEdgeRecombination split() {
        return this;
    }

    private void build(int[] raw, EnhancedEdgeMap map) {
        for (int i = 1; i < raw.length; ++i) {
            map.used(raw[i - 1]);
            raw[i] = map.pick(raw[i - 1]);
        }
    }

    static final class EnhancedEdgeMap {
        final int[][] adj;
        final int[] count;
        final boolean[] done;

        EnhancedEdgeMap(int[] raw1, int[] raw2) {
            int i;
            this.adj = new int[raw1.length][4];
            this.count = new int[raw1.length];
            this.done = new boolean[raw1.length];
            boolean[][] in = new boolean[raw1.length][raw1.length];
            this.adj[raw1[0]][0] = raw1[raw1.length - 1];
            in[raw1[0]][raw1[raw1.length - 1]] = true;
            for (i = 1; i < raw1.length; ++i) {
                this.adj[raw1[i]][0] = raw1[i - 1];
                in[raw1[i]][raw1[i - 1]] = true;
            }
            if (raw1.length <= 2) {
                Arrays.fill(this.count, 1);
            } else {
                Arrays.fill(this.count, 2);
                this.adj[raw1[raw1.length - 1]][1] = raw1[0];
                in[raw1[raw1.length - 1]][raw1[0]] = true;
                for (i = 1; i < raw1.length; ++i) {
                    this.adj[raw1[i - 1]][1] = raw1[i];
                    in[raw1[i - 1]][raw1[i]] = true;
                }
                if (!in[raw2[0]][raw2[raw2.length - 1]]) {
                    this.adj[raw2[0]][this.count[raw2[0]]] = raw2[raw2.length - 1];
                    in[raw2[0]][raw2[raw2.length - 1]] = true;
                    int n = raw2[0];
                    this.count[n] = this.count[n] + 1;
                } else {
                    this.negate(raw2[0], raw2[raw2.length - 1]);
                }
                if (!in[raw2[raw2.length - 1]][raw2[0]]) {
                    this.adj[raw2[raw2.length - 1]][this.count[raw2[raw2.length - 1]]] = raw2[0];
                    in[raw2[raw2.length - 1]][raw2[0]] = true;
                    int n = raw2[raw2.length - 1];
                    this.count[n] = this.count[n] + 1;
                } else {
                    this.negate(raw2[raw2.length - 1], raw2[0]);
                }
                for (i = 1; i < raw2.length; ++i) {
                    if (!in[raw2[i]][raw2[i - 1]]) {
                        this.adj[raw2[i]][this.count[raw2[i]]] = raw2[i - 1];
                        in[raw2[i]][raw2[i - 1]] = true;
                        int n = raw2[i];
                        this.count[n] = this.count[n] + 1;
                    } else {
                        this.negate(raw2[i], raw2[i - 1]);
                    }
                    if (!in[raw2[i - 1]][raw2[i]]) {
                        this.adj[raw2[i - 1]][this.count[raw2[i - 1]]] = raw2[i];
                        in[raw2[i - 1]][raw2[i]] = true;
                        int n = raw2[i - 1];
                        this.count[n] = this.count[n] + 1;
                        continue;
                    }
                    this.negate(raw2[i - 1], raw2[i]);
                }
                for (i = 0; i < this.count.length; ++i) {
                    if (this.count[i] != 2) continue;
                    this.adj[i][0] = -(this.adj[i][0] + 1);
                    this.adj[i][1] = -(this.adj[i][1] + 1);
                }
            }
        }

        EnhancedEdgeMap(EnhancedEdgeMap other) {
            this.count = (int[])other.count.clone();
            this.done = new boolean[this.count.length];
            this.adj = new int[other.adj.length][];
            for (int i = 0; i < this.adj.length; ++i) {
                this.adj[i] = (int[])other.adj[i].clone();
            }
        }

        final int pick(int from) {
            if (this.count[from] == 1) {
                return this.negateIfNecessary(this.adj[from][0]);
            }
            if (this.count[from] > 0) {
                if (this.adj[from][0] < 0) {
                    return -(this.adj[from][0] + 1);
                }
                int[] minIndexes = new int[4];
                int num = 1;
                for (int i = 1; i < this.count[from]; ++i) {
                    if (this.adj[from][i] < 0) {
                        return -(this.adj[from][i] + 1);
                    }
                    if (this.count[this.adj[from][i]] < this.count[this.adj[from][minIndexes[0]]]) {
                        minIndexes[0] = i;
                        num = 1;
                        continue;
                    }
                    if (this.count[this.adj[from][i]] != this.count[this.adj[from][minIndexes[0]]]) continue;
                    minIndexes[num] = i;
                    ++num;
                }
                if (num > 1) {
                    return this.adj[from][minIndexes[RandomIndexer.nextBiasedInt((int)num)]];
                }
                return this.adj[from][minIndexes[0]];
            }
            return this.anyRemaining();
        }

        final void used(int element) {
            for (int i = 0; i < this.count[element]; ++i) {
                this.remove(this.negateIfNecessary(this.adj[element][i]), element);
            }
            this.done[element] = true;
        }

        final void remove(int list, int element) {
            int i = 0;
            while (this.negateIfNecessary(this.adj[list][i]) != element) {
                ++i;
            }
            int n = list;
            this.count[n] = this.count[n] - 1;
            this.adj[list][i] = this.adj[list][this.count[list]];
        }

        final int anyRemaining() {
            int[] minIndexes = new int[this.adj.length];
            int num = 0;
            for (int i = 0; i < this.done.length; ++i) {
                if (this.done[i]) continue;
                if (num == 0) {
                    minIndexes[0] = i;
                    num = 1;
                    continue;
                }
                if (this.count[i] == this.count[minIndexes[0]]) {
                    minIndexes[num] = i;
                    ++num;
                    continue;
                }
                if (this.count[i] >= this.count[minIndexes[0]]) continue;
                minIndexes[0] = i;
                num = 1;
            }
            if (num > 1) {
                return minIndexes[RandomIndexer.nextBiasedInt((int)num)];
            }
            if (num == 1) {
                return minIndexes[0];
            }
            return -1;
        }

        private void negate(int u, int v) {
            int i = 0;
            while (this.adj[u][i] != v) {
                ++i;
            }
            this.adj[u][i] = -(v + 1);
        }

        private int negateIfNecessary(int e) {
            return e >= 0 ? e : -(e + 1);
        }
    }
}

