/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators.permutations;

import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.permutations.Permutation;
import org.cicirello.search.operators.CrossoverOperator;

public final class CycleCrossover
implements CrossoverOperator<Permutation> {
    @Override
    public void cross(Permutation c1, Permutation c2) {
        c1.apply((raw1, raw2, p1, p2) -> {
            boolean[] inCycle = new boolean[raw1.length];
            int[] cycle = new int[raw1.length];
            int count = 0;
            int[] inv1 = p1.getInverse();
            int i = RandomIndexer.nextInt((int)raw1.length);
            while (!inCycle[i]) {
                inCycle[i] = true;
                cycle[count] = i;
                ++count;
                i = inv1[raw2[i]];
            }
            for (i = 0; i < count; ++i) {
                int temp = raw1[cycle[i]];
                raw1[cycle[i]] = raw2[cycle[i]];
                raw2[cycle[i]] = temp;
            }
        }, c2);
    }

    @Override
    public CycleCrossover split() {
        return this;
    }
}

