/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators.permutations;

import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.permutations.Permutation;
import org.cicirello.search.operators.IterableMutationOperator;
import org.cicirello.search.operators.MutationIterator;
import org.cicirello.search.operators.UndoableMutationOperator;
import org.cicirello.search.operators.permutations.BlockMoveIterator;

public class BlockMoveMutation
implements UndoableMutationOperator<Permutation>,
IterableMutationOperator<Permutation> {
    private final int[] indexes = new int[3];

    @Override
    public final void mutate(Permutation c) {
        if (c.length() >= 2) {
            this.generateIndexes(c.length(), this.indexes);
            c.removeAndInsert(this.indexes[1], this.indexes[2] - this.indexes[1] + 1, this.indexes[0]);
        }
    }

    @Override
    public final void undo(Permutation c) {
        c.removeAndInsert(this.indexes[0], this.indexes[2] - this.indexes[1] + 1, this.indexes[1]);
    }

    @Override
    public BlockMoveMutation split() {
        return new BlockMoveMutation();
    }

    @Override
    public MutationIterator iterator(Permutation p) {
        return new BlockMoveIterator(p);
    }

    void generateIndexes(int n, int[] indexes) {
        RandomIndexer.nextIntTriple((int)(n + 1), (int[])indexes, (boolean)true);
        if (indexes[2] == n) {
            indexes[2] = indexes[1];
        }
    }
}

