/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators.permutations;

import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.permutations.Permutation;
import org.cicirello.search.operators.IterableMutationOperator;
import org.cicirello.search.operators.MutationIterator;
import org.cicirello.search.operators.UndoableMutationOperator;
import org.cicirello.search.operators.permutations.AdjacentSwapIterator;

public final class AdjacentSwapMutation
implements UndoableMutationOperator<Permutation>,
IterableMutationOperator<Permutation> {
    private int index;

    @Override
    public void mutate(Permutation c) {
        if (c.length() >= 2) {
            this.index = RandomIndexer.nextInt((int)(c.length() - 1));
            c.swap(this.index, this.index + 1);
        }
    }

    @Override
    public void undo(Permutation c) {
        if (c.length() >= 2) {
            c.swap(this.index, this.index + 1);
        }
    }

    @Override
    public AdjacentSwapMutation split() {
        return new AdjacentSwapMutation();
    }

    @Override
    public MutationIterator iterator(Permutation p) {
        return new AdjacentSwapIterator(p);
    }
}

