/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators.integers;

import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.search.operators.CrossoverOperator;
import org.cicirello.search.representations.IntegerVector;

public final class TwoPointCrossover<T extends IntegerVector>
implements CrossoverOperator<T> {
    private final int[] indexes = new int[2];

    @Override
    public void cross(IntegerVector c1, IntegerVector c2) {
        RandomIndexer.nextIntPair((int)c1.length(), (int[])this.indexes);
        if (this.indexes[1] > this.indexes[0]) {
            IntegerVector.exchange(c1, c2, this.indexes[0], this.indexes[1] - 1);
        } else {
            IntegerVector.exchange(c1, c2, this.indexes[1], this.indexes[0] - 1);
        }
    }

    @Override
    public TwoPointCrossover<T> split() {
        return new TwoPointCrossover<T>();
    }
}

