/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators.integers;

import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.math.rand.RandomVariates;
import org.cicirello.search.operators.MutationOperator;
import org.cicirello.search.representations.IntegerValued;

public class RandomValueChangeMutation<T extends IntegerValued>
implements MutationOperator<T> {
    private final double p;
    private final int a;
    private final int b;
    private final int range;
    private final int min_k;
    private int[] indexes;
    private int lastK;

    public RandomValueChangeMutation(int a, int b) {
        this(a, b, 0.0, 1);
    }

    public RandomValueChangeMutation(int a, int b, double p) {
        this(a, b, p, 0);
    }

    public RandomValueChangeMutation(int a, int b, double p, int k) {
        this.range = b - a + 1;
        if (this.range <= 1) {
            throw new IllegalArgumentException("b must be greater than a");
        }
        this.a = a;
        this.b = b;
        this.p = p <= 0.0 ? 0.0 : (p >= 1.0 ? 1.0 : p);
        this.min_k = k <= 0 ? 0 : k;
    }

    RandomValueChangeMutation(RandomValueChangeMutation<T> other) {
        this.a = other.a;
        this.b = other.b;
        this.p = other.p;
        this.min_k = other.min_k;
        this.range = other.range;
    }

    @Override
    public void mutate(T c) {
        if (c.length() == 0) {
            return;
        }
        int min = c.length() < this.min_k ? c.length() : this.min_k;
        int n = this.lastK = this.p > 0.0 ? RandomVariates.nextBinomial((int)c.length(), (double)this.p) : min;
        if (this.lastK < min) {
            this.lastK = min;
        }
        this.indexes = RandomIndexer.sample((int)c.length(), (int)this.lastK, (int[])this.indexes);
        for (int i = 0; i < this.lastK; ++i) {
            int v = this.a + RandomIndexer.nextInt((int)(this.range - 1));
            if (v >= c.get(this.indexes[i])) {
                ++v;
            }
            c.set(this.indexes[i], v);
        }
    }

    @Override
    public RandomValueChangeMutation<T> split() {
        return new RandomValueChangeMutation<T>(this.a, this.b, this.p, this.min_k);
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof RandomValueChangeMutation)) {
            return false;
        }
        RandomValueChangeMutation m = (RandomValueChangeMutation)other;
        return m.a == this.a && m.b == this.b && m.p == this.p && m.min_k == this.min_k;
    }

    public int hashCode() {
        return 31 * (31 * (31 * Double.hashCode(this.p) + this.a) + this.b) + this.min_k;
    }

    void restorableMutate(T c, int[] old) {
        int min = c.length() < this.min_k ? c.length() : this.min_k;
        int n = this.lastK = this.p > 0.0 ? RandomVariates.nextBinomial((int)c.length(), (double)this.p) : min;
        if (this.lastK < min) {
            this.lastK = min;
        }
        this.indexes = RandomIndexer.sample((int)c.length(), (int)this.lastK, (int[])this.indexes);
        for (int i = 0; i < this.lastK; ++i) {
            int v = this.a + RandomIndexer.nextInt((int)(this.range - 1));
            old[i] = c.get(this.indexes[i]);
            if (v >= old[i]) {
                ++v;
            }
            c.set(this.indexes[i], v);
        }
    }

    void restore(T c, int[] old) {
        for (int i = 0; i < this.lastK; ++i) {
            c.set(this.indexes[i], old[i]);
        }
    }
}

